# Требования к интерфейсу авторизации на сервисе

Авторизация происходит при помощи перенаправления пользователя на страницу [https://passport.yandex.ru/auth](https://passport.yandex.ru/auth).

Вы можете реализовать интерфейс авторизации следующими способами:

- Если вы не используете библиотеку блоков [Лего](https://lego.yandex-team.ru), добавьте кнопку **Войти**, которая перенаправит пользователя по ссылке `https://passport.yandex.ru/auth?origin=<идентификатор_сервиса>&retpath=<url>&backpath=<url>`.

    Параметры:

    #### origin
    [Идентификатор вашего сервиса](#section_whc_5rc_ygb). Обязательный параметр.
    #### retpath
    Url, куда нужно вернуть пользователя после авторизации. Необязательный параметр. Если параметр не указан, пользователь будет перенаправлен на [страницу Паспорта](https://passport.yandex.ru/profile).
    #### backpath
    Url, куда нужно вернуть пользователя при нажатии кнопки **Вернуться на сервис**. Необязательный параметр. Если параметр не указан, будет использовано значение из параметра `retpath`.

    Пример ссылки:

    ```
    https://passport.yandex.ru/auth?origin=mail&retpath=https://mail.yandex.ru&backpath=https://mail.yandex.ru/inbox
    ```

- Если вы используете библиотеку блоков [Лего](https://lego.yandex-team.ru), добавьте и настройте [блок авторизации user2](https://lego.yandex-team.ru/libs/islands/v5.20.0/desktop/user2/). Для неавторизованного пользователя данный блок будет содержать кнопку **Войти**, которая перенаправит пользователя на страницу авторизации.

    При настройке данного блока также необходимо указать [идентификатор вашего сервиса](#section_whc_5rc_ygb).


## Идентификатор потребителя {#section_whc_5rc_ygb}

При перенаправлении пользователей на единую страницу авторизации необходимо передавать идентификатор вашего сервиса (идентификатор потребителя). Чтобы получить идентификатор, создайте задачу в очереди [PASSP](https://st.yandex-team.ru/passp) в Стартреке и укажите ваш сервис.

Идентификатор потребителя позволяет [отслеживать конверсию пользователей](#conversion) и [настраивать внешний вид страницы авторизации](#customization).

#### Отслеживание конверсии

Паспорт собирает статистику о том, какое количество посетителей вашего сервиса сконвертировалось в авторизованных пользователей.

Если вы хотите знать конверсию для различных сценариев вашего сервиса, используйте несколько различных идентификаторов. Для этого добавьте к идентификатору, выданному Паспортом, постфиксы вида `_<сценарий1>` и `_<сценарий2>`. Например, если идентификатор вашего сервиса — `market`, вы можете использовать постфиксы `_mobile` и `_desktop` в зависимости от версии вашего сайта.

Чтобы учесть авторизации для нескольких сервисов сразу, перечислите идентификаторы отдельных сервисов, разделив их символами `__` (два подчеркивания). Например, `<сервис1>__<сервис2>_<сценарий1>`.

Статистика конверсии собирается в отчет по сервисам.

Пример отчета за 26.01.2019:

origin|	Открытия|	Авторизации|	Конверсия (%)|
----- | ----- | ---- | ----|
market | 443477 | 176243 | 39,74% |
 market_mobile | 441655 | 175620 | 39,76%|
 market_desktop | 645 | 282 | 43,72%|
 ... | ... | ... | ...|

Чтобы получить отчет по конверсиям для вашего сервиса, напишите на рассылку [passport-dev](mailto:passport-dev@yandex-team.ru).

#### Настройка внешнего вида страницы авторизации

При необходимости, на [странице авторизации](https://passport.yandex.ru/auth/welcome) вы можете изменить:

- Текст приветствия, по умолчанию — <q>Войдите, чтобы продолжить</q>.
- Фоновое изображение.
Внешний вид страницы привязан к идентификатору потребителя. Если вы хотите иметь разные страницы авторизации для разных задач, используйте несколько идентификаторов, например — `market_desktop` и `market_mobile`.
Чтобы заказать настройку внешнего вида страницы, создайте задачу в очереди [PASSP](https://st.yandex-team.ru/passp).

В задаче:

- Укажите идентификатор потребителя.
- Укажите текст приветствия.

    Ограничение для текста — максимум 72 символа, максимум 2 строки.

- Приложите фоновую картинку.

