# Разные аккаунты в одном браузере

Мультиавторизация предполагает, что пользователь может быть одновременно авторизован с разными аккаунтами Яндекса во вкладках одного браузера. Эту возможность должны поддерживать персональные сервисы, чтобы не соперничать друг с другом за основной аккаунт в куке `Session_id`.

> # Пример конфликта вкладок
> 
> Допустим, Почта не поддерживает разные аккаунты во вкладках.
> 
> Пользователь:
> 
> 1. Авторизуется на Почте с аккаунтом `alisa` и начинает писать письмо.
>     
> 1. Открывает Паспорт в новой вкладке и переключается на аккаунт `bob` (этот аккаунт становится основным в куке `Session_id`).
>     
> 1. Возвращается во вкладку с Почтой и нажимает кнопку **Отправить**.
>     
> 
> Почта выполняет действие для основного аккаунта в куке на текущий момент — письмо отправляется от аккаунта `bob`. Но пользователь уверен, что отправил письмо с аккаунта `alisa`: вкладка Почты все еще отображает письма и личные данные именно этого аккаунта. Обнаружив подмену, пользователь негодует. Аналогичные ошибки могут произойти на любом персональном сервисе: Деньгах, Маркете, Метрике, Диске и т. д.

Чтобы решить задачу разных аккаунтов в разных вкладках:

1. Каждая вкладка, в которой открыта страница сервиса, должна отправлять запросы на сервер только для одного аккаунта: того, который пользователь явно указал в этой вкладке (авторизовался или самостоятельно сделал основным). Для этого нужный аккаунт следует закреплять на вкладке одним из следующих способов:
    
    - [Привязать интерфейс на вкладке к UID](#uid-identification) закрепляемого аккаунта.
    
    - Сохранять куку `yandex_login` закрепляемого аккаунта. По изменениям этой куки можно судить о том, что изменился и основной аккаунт в куке `Session_id`. Это значит, что основной аккаунт нужно переключить обратно (см. [пункт 3](#switch)).
    
    {% note info %}
    
    Не рекомендуется рассчитывать на консистентность и обратную совместимость куки `yandex_login`. Привязка интерфейса к UID надежнее и предсказуемее, хотя и более трудозатратна.
    
    {% endnote %}
    
1. Вкладка должна показывать результат работы сервера только тому аккаунту, от имени которого был отправлен запрос. Для этого сервер должен возвращать в ответах UID аккаунта, для которого была запрошена операция.
    
    Это необходимо, чтобы пользователи не могли случайно увидеть данные другого аккаунта: получая UID от сервера, вкладка может проверить, остался ли закрепленным соответствующий аккаунт между отправкой запроса и получением ответа.
    
1. Пользователь должен оставаться авторизованным с закрепленным аккаунтом, переходя на другой сервис Яндекса в той же вкладке. Для этого нужно пытаться автоматически [переключать основной аккаунт](#cookie-rewrite) в куке `Session_id` на закрепленный, когда пользователь возвращается на вкладку.
    
    Если интерфейс на вкладке не [привязан к UID](#uid-identification), автоматическое переключение основного аккаунта также поможет пользователю продолжить работу с закрепленным аккаунтом.
    
    {% note info %}
    
    Автоматическое переключение основного аккаунта в куке может занять значительное время, в течение которого нельзя понять, каким аккаунтом управляет пользователь. Чтобы избежать этой неопределенности, следует также [привязывать интерфейс вкладки к UID](#uid-identification).
    
    {% endnote %}
    

## Автоматическое переключение основного аккаунта {#cookie-rewrite}

Когда пользователь возвращается на вкладку, которая закреплена за определенным аккаунтом, браузер должен пытаться сделать закрепленный аккаунт основным в куке `Session_id`:

- Следить за активацией вкладки. Как только вкладка был активирована, нужно проверить:
    
    - остался ли в куке `Session_id` аккаунт с закрепленным UID (передать куку и UID в метод Черного ящика [sessionid](https://doc.yandex-team.ru/blackbox/reference/MethodSessionID.xml));
    
    - изменился ли основной аккаунт (сравнить закрепленный UID или куку `yandex_login` с текущими).
    
- Обработать результат проверок:
    
    - Если аккаунт остался в куке `Session id` и остался основным, ничего делать не нужно — пользователь может продолжать работу.
    
    - Если аккаунт остался в куке, но перестал быть основным, следует переключиться на него: отправить POST-запрос к режиму [embeddedauth](https://beta.wiki.yandex-team.ru/passport/frontend/embeddedauth-multiauth/) с параметром `action=change_default` и сохраненным UID.
    
    - Если закрепленного аккаунта в куке нет, метод [sessionid](https://doc.yandex-team.ru/blackbox/reference/MethodSessionID.xml) вернет ошибку, которую нужно обработать согласно логике сервиса. Браузер не должен отправлять запросы и отображать результаты работы сервера для аккаунта, который уже не авторизован на сервисе.
    
    Например, можно предложить пользователю авторизоваться заново или авторизовать его с другим аккаунтом, явно сообщив об этом.
    

## Привязка UID к интерфейсу вкладки {#uid-identification}

Привязка UID предполагает, что с каждым запросом из браузера на сервер отправляется также UID аккаунта, для которого выполняется операция.

Например, в Почте (которая использует этот способ) кнопка пересылки письма содержит следующую ссылку:

```no-highlight
https://mail.yandex.ru/?
uid=12345678
&login=test
#compose/oper=forward&ids=34405500006531389038
```

Если пользователь поменяет основной аккаунт в куке `Session_id` на другом сервисе и вернется на вкладку Почты, чтобы переслать письмо, эта операция все равно будет выполнена для UID 12345678.

