# Подключение к API Яндекс ID

Чтобы использовать API Яндекс ID в веб-приложении, необходимо:

- [зарегистрировать](../../oauth/tasks/register-client.md) приложение на сервисе [{{ service }}]{% if lang == "ru" %}(https://oauth.yandex.ru/){% endif %}{% if lang == "en" %}(https://oauth.yandex.com){% endif %};
- реализовать в приложении получение и обработку OAuth-токенов;
- предоставить пользователям интерфейс входа через Яндекс.

## Регистрация приложения на {{ service }} {#oauth-register}

Вход через Яндекс требует получения OAuth-токена для каждого нового пользователя. Чтобы получать OAuth-токены, сайты и приложения должны регистрироваться на [{{ service }}]{% if lang == "ru" %}(https://oauth.yandex.ru/){% endif %}{% if lang == "en" %}(https://oauth.yandex.com){% endif %}, в разделе [Регистрация клиентских приложений]{% if lang == "ru" %}(https://oauth.yandex.ru/client/my){% endif %}{% if lang == "en" %}(https://oauth.yandex.com/client/my){% endif %}.

Подробно этот процесс описан в разделе [Регистрация приложения](../../oauth/tasks/register-client.md) документации OAuth-сервиса Яндекса.

## Получение OAuth-токенов {#oauth-receive}

Чтобы получить OAuth-токен, следуйте [инструкции для веб-приложений](../../oauth/reference/web-client.md). Ссылку можно оформить в виде кнопки с логотипом Яндекса (см. [{#T}](../reference/buttons.md)).

Полученный токен следует указывать при каждом вызове API Яндекс ID, в заголовке `Authorization` или в значении HTTP-параметра `oauth_token`.

OAuth-токен следует запрашивать для каждого нового пользователя вашего сайта или приложения, который входит через Яндекс.

## Общие сведения о протоколе OAuth {#oauth-general}

Описание реализации протокола OAuth в Яндексе приведено в [документации API](https://tech.yandex.ru/oauth/).

Для работы с протоколом вы можете использовать множество [библиотек для различных языков программирования](http://oauth.net/code/).

