# Переход к API Яндекс ID от OpenID

Идентификаторы OpenID, провайдером которых является Яндекс, перестали работать 10 августа 2015 года. Авторизоваться на других сайтах с аккаунтом Яндекса можно будет с помощью нового и более безопасного API Яндекс ID.

## Пользователям {#user}

После 10 августа 2015 года вы сможете входить на другие сайты через Яндекс, только если разработчик сайта правильно реализовал переход от OpenID. Если вы не можете войти на сайт с аккаунтом Яндекса, обратитесь в службу поддержки сайта.

## Разработчикам сайтов и вебмастерам {#webmaster}

Пользователи, которые входят на ваш сайт с OpenID Яндекса, 10 августа потеряют эту возможность. Вы можете авторизовать таких пользователей с помощью API Яндекс ID.

API также поможет предоставить пользователям доступ к старым аккаунтам, привязанным к OpenID. Для этого, [подключив API Яндекс ID](adoption.md), нужно специальным образом обрабатывать вход:

1. Если пользователь вручную вводит OpenID-идентификатор Яндекса, сообщите, что войти таким образом больше нельзя, и предложите войти с помощью API Яндекс ID.

   Идентификаторы Яндекса можно узнать по домену в URL: `yandex.ru` или `ya.ru`.
    
   Если пользователь просто нажимает на кнопку входа через Яндекс, авторизуйте его через API Яндекс ID.
    
1. Запросите OAuth-токен для доступа к данным пользователя.
    
1. [Запросите](../reference/request.md) нужные данные через API Яндекс ID. Чтобы получить возможные OpenID-идентификаторы пользователя, передайте также параметр `with_openid_identity`.
    
1. Ищите каждый OpenID-идентификатор из полученного списка в вашей базе данных аккаунтов:
    
   - Если ни одного аккаунта с полученными OpenID-идентификаторами не нашлось, просто авторизуйте пользователя с помощью API Яндекс ID.
   
   - Если нашелся один аккаунт, свяжите его с идентификатором учетной записи в Яндексе (элемент `id` в ответе API Яндекс ID). Затем используйте API, чтобы авторизовать пользователя.
   
   - Если нашлось несколько аккаунтов с полученными OpenID-идентификаторами, предложите пользователю выбрать тот, с которым он хочет авторизоваться. Выбранный аккаунт свяжите с идентификатором учетной записи в Яндексе, а затем авторизуйте пользователя с помощью API Яндекс ID.

Таким образом пользователь сможет входить на ваш сайт через Яндекс, а вы при первой необходимости привяжете данные старого OpenID-аккаунта к уникальному идентификатору пользователя Яндекса.
