# Запрос информации о пользователе

По запросу информации о пользователе API Яндекс ID возвращает все данные, права на которые дает указанный в запросе OAuth-токен.

Запрос информации о пользователе Яндекса формируется следующим образом:

{% list tabs %}

- Рекомендуемый способ

  ```no-highlight
  GET https://login.yandex.ru/info?
  [  format=json | xml | jwt]
  [& jwt_secret=<Cекретный ключ>]
  [& with_openid_identity=1 | yes | true]

  Authorization: OAuth <OAuth-токен>
  ```

- Небезопасный способ

  При использовании этого способа OAuth-токен передается в параметре GET-запроса и может сохраниться в открытом виде в истории браузера или в access-логах любого промежуточного хоста. Сохраненным OAuth-токеном может воспользоваться злоумышленник.

  ```no-highlight
  GET https://login.yandex.ru/info?
  [  format=json | xml| jwt]
  [& with_openid_identity=1 | yes | true]
  [& oauth_token=<OAuth-токен>]
  ```

{% endlist %}

Параметры запроса:

#|
|| **Параметр** | **Значение** | **Описание** ||
||`format` | xml \| json \| jwt | Формат возвращаемых данных. Возможные значения:

* «json» — возвращается JSON-документ. Это значение используется по умолчанию, если параметр не указан в запросе.
* «xml» — возвращается XML-документ.
* «jwt» — возвращается [JSON Web Token](../concepts/jwt.md). ||
|| `jwt_secret` | <Cекретный_ключ> | Секрет, которым будет подписан JWT. Если параметр не передан — вместо него будет использован client_secret OAuth-приложения.
Рекомендуется этот параметр не передавать. ||
|| `with_openid_identity` | 1 \| yes \| true | Признак запроса OpenID-идентификаторов, которые пользователь мог получить от Яндекса. Список включается в [ответ](response.md) в JSON-массиве/элементе XML `openid_identities`.

Чтобы запросить идентификаторы, укажите значение <q>1</q>, <q>yes</q> или <q>true</q>. При любом другом значении параметр игнорируется.

Параметр используется при [миграции с OpenID Яндекса](../concepts/openid-migrate.md) на API Яндекс ID. ||
|| `oauth_token` | <OAuth-токен> | OAuth-токен, который разрешает доступ к данным учетной записи пользователя через API Яндекс ID. От прав, которые дает указанный в запросе OAuth-токен, зависит содержание [ответа](response.md).

OAuth-токен должен быть указан в запросе одним из двух способов:

* В HTTP-заголовке `Authorization` при каждом вызове API Яндекс ID с указанием типа токена перед его значением (рекомендуемый способ):

  ```
  Authorization: OAuth <OAuth-токен>
  ```

* В значении параметра `oauth_token` (небезопасный и нерекомендуемый способ):

  ```
  oauth_token=<OAuth-токен>
  ```
||
|#


