# Токен для устройства

Яндекс.OAuth позволяет запросить токен для приложения на конкретном устройстве. Для этого в запросе токена или кода подтверждения следует указать идентификатор устройства и его имя (параметры `device_id` и `device_name` описаны в форматах запросов на страницах этого документа). Это имя пользователь сможет увидеть на [странице управления доступом]{% if lang == "ru" %}(https://passport.yandex.ru/profile/access){% endif %}{% if lang == "en" %}(https://passport.yandex.com/profile/access){% endif %} в Яндекс ID. Если указать только идентификатор, без имени, токен будет помечен как выданный для неизвестного устройства.

{% include [device-token-limit](../../_includes/oauth/concepts/device-token/id-device-token/limit.md) %}

## Отзыв токена на определенном устройстве {#device-token-revoke}

Токен, выданный для определенного устройства, можно отозвать запросом к {{ service }}, например, чтобы гарантировать выход из аккаунта.

Чтобы отозвать токен, нужно передать его в {{ service }} с идентификатором и паролем приложения.

### Аутентификация приложения {#app-auth}

В запросах к {{ service }} следует указывать идентификатор и пароль, которые были сгенерированы при регистрации приложения.

В запросе их можно передать разными способами:

- В заголовке `Authorization`, в строке `<client_id>:<client_secret>`, закодированной методом base64. При этом следует указывать базовый (`Basic`) метод авторизации.

  Пример заголовка:

  ```no-highlight
  Authorization: Basic NDc2MDE4N2Q4MWJjNGI3Nzk5NDc2YjQycjUxMDM3MTM6ZjI1YmViZjk5MWZmNDE5ODkzZGIyNTU3MjhlNGUxZGU=
  ```

- В теле POST-запроса, в параметрах `client_id` и `client_secret`. Эти параметры обязательно должны передаваться одновременно.

Если {{ service }} получает заголовок `Authorization`, параметры `client_id` и `client_secre`t в теле запроса игнорируются.

### Формат запроса {#cleartext}

Запрос следует отправлять по протоколу HTTPS c помощью метода POST.

Формат запроса для отзыва токена:

```no-highlight
POST /revoke_token HTTP/1.1
Host: oauth.yandex.ru
Content-type: application/x-www-form-urlencoded
Content-Length: `<`длина тела запроса`>`
[Authorization: Basic `<`закодированная строка client_id:client_secret`>`]

   access_token=<отзываемый токен>
[& client_id=`<`идентификатор приложения`>`]
[& client_secret=`<`пароль приложения`>`]
```

#|
|| **Параметр** | **Описание** ||
|| **Обязательный параметр** ||
|| `access_token` | OAuth-токен, который нужно отозвать. ||
|| **Дополнительные параметры** ||
|| `client_id` | Идентификатор приложения. Доступен в [свойствах приложения]{% if lang == "ru" %}(https://oauth.yandex.ru/){% endif %}{% if lang == "en" %}(https://oauth.yandex.com/){% endif %} (нажмите название приложения, чтобы открыть его свойства).

{% include [auth-link](../../_includes/oauth/auth-link.md) %} ||
|| `client_secret` | Пароль приложения. Доступен в [свойствах приложения]{% if lang == "ru" %}(https://oauth.yandex.ru/){% endif %}{% if lang == "en" %}(https://oauth.yandex.com/){% endif %} (нажмите название приложения, чтобы открыть его свойства).

{% include [auth-link](../../_includes/oauth/auth-link.md) %} ||
|#

### Формат ответа {#response}

Яндекс.OAuth возвращает ответ в JSON-документе.

{% list tabs %}

- Токен успешно отозван или уже был недействителен

  Возвращается ответ с HTTP-кодом 200 и следующим телом:

  ```javascript
  {
    "status": "ok"
  }
  ```

- Произошла ошибка

  Если запрос выполнить не удалось, то ответ возвращается с HTTP-кодом ошибки и ее описанием:

  ```javascript
  {
    "error_description": "Client not found",
    "error": "invalid_client"
  }
  ```
  Ключ | Описание
  ---- | ----
  `error_description` | Описание ошибки на естественном языке.
  `error` | Код ошибки. Список возможных кодов приведен в таблице ниже.

{% endlist %}

### Поддерживаемые коды ошибок {#error-table}

#|
|| **HTTP-код ответа** | **Код ошибки** | **Описание** ||
|| 400 | invalid_request | Неверный формат запроса (не указан обязательный параметр и т. п.). ||
|| 400 | invalid_grant | Переданный токен не принадлежит указанному приложению. ||
|| 400 или 401 | invalid_client | Возвращается в следующих случаях:
- Приложение с указанным идентификатором не найдено или заблокировано.
- Передан неверный пароль для заданного идентификатора приложения.

HTTP-код ответа 401 возвращается, если идентификатор и пароль приложения были переданы в заголовке `Authorization`. В противном случае возвращается HTTP-код 400. ||
|| 400 | unsupported_token_type | Токен не может быть отозван, так как при запросе этого токена не был указан идентификатор устройства (параметр `device_id`).

Если токен нельзя отозвать, его можно просто удалить из локального хранилища, чтобы приложение потеряло доступ к данным пользователя. ||
|#
