# Реализация OAuth в Яндексе

Сервисы Яндекса авторизуют приложения по токенам. Каждый токен — это цифро-буквенная последовательность, в которой зашифрована следующая информация:

- идентификатор учетной записи, к которой разрешен доступ;
    
- идентификатор приложения, которому разрешен доступ;
    
- набор прав (действий, доступных приложению).
    
Ниже описаны общие правила использования OAuth-токенов Яндекса.

## Процедура авторизации {#authorization-scheme}

Приложения запрашивают токены по следующей схеме:

![image](../../_assets/authorization.png)

1. Приложение направляет пользователя на OAuth-сервер. На открывшейся странице он может разрешить приложению доступ к запрошенным данным своей учетной записи. Приложение может запросить: {#step-1}
    
   - Все права доступа, указанные при регистрации приложения. В этом случае пользователь может разрешить или запретить только все запрошенные доступы сразу.
   - Только необходимые в данный момент права доступа из перечня, определенного при регистрации приложения. В этом случае пользователь также может разрешить или запретить только все запрошенные доступы сразу.
   - Необходимые в данный момент права доступа из перечня, определенного при регистрации приложения, и опциональные права из того же перечня, без которых можно обойтись. Опциональным может являться, например, доступ к портрету. В этом случае пользователь может разрешить все запрошенные необходимые доступы сразу и выбрать, какие из запрошенных опциональных доступов разрешить.
    
1. Пользователь разрешает доступ к своим данным, и OAuth-сервер перенаправляет его на выбранный разработчиком адрес.
    
   Выданный токен (или код для его получения) включается в URL перенаправления. Если пользователь отказал в доступе, или произошла ошибка, в URL включается описание ошибки.

   {% if audience == "internal" %}
   
   {% note info %}
   
   Альтернативные способы получить токен ― [по сессионной куке](../reference/internal-tokens/sessionid.md), [по логину и паролю](../reference/internal-tokens/login-password.md), а также [по X-токену](../reference/internal-tokens/xtoken.md). Чтобы получить OAuth-токен по логину и паролю, нужно запросить их у пользователя, поэтому этот способ по возможности не используйте.
   
   {% endnote %}
   
   {% endif %}

1. Приложение включает полученный токен в запрос к сервису Яндекса, который поддерживает OAuth.
    
Полученный токен можно сохранить в приложении и использовать для запросов до истечения времени его жизни.

## Время жизни токена {#ttl}

Время жизни токена — это срок, в течение которого токен можно использовать для авторизации. Максимальное время жизни зависит от прав, выбранных при [регистрации приложения](../tasks/register-client.md#scope):

Вечный токен

:    Никогда не устаревает и может быть отозван только пользователем.

     При регистрации приложения отображается время жизни «бесконечно».

Продлеваемый токен

:    Устаревает после нескольких месяцев, но продлевается при каждой авторизации с этим токеном.

     При регистрации приложения отображается минимальное время жизни, например, <q>не менее, чем 1 год</q>.

Ограниченный токен

:    Устаревает по истечении времени, установленного для соответствующих прав доступа.

     Если при регистрации приложения было выбрано несколько таких прав, для токена выбирается наименьшее ограничение времени жизни. Допустим, права для доступа к Яндекс.Метрике выдаются на 1 год, а права на использование Яндекс.Почтового офиса — на 180 дней. Значит, токен с правами и для Метрики, и для Почтового офиса, будет работать не дольше 180 дней.

## Отзыв токена {#token-recall}

Пользователь может отзывать любые OAuth-токены, выданные для его аккаунта:

- Чтобы отозвать токены, когда-либо выданные для учетной записи, пользователь может сменить пароль или [выйти на всех компьютерах]{% if lang == "ru" %}(https://yandex.ru/support/passport/faq.html#faq__glogout){% endif %}{% if lang == "en" %}(https://yandex.com/support/passport/faq.html#faq__glogout){% endif %}.
- Чтобы отозвать токены, выданные определенному приложению, пользователь может запретить доступ для него на странице [Управление доступом]{% if lang == "ru" %}(https://passport.yandex.ru/profile/access){% endif %}{% if lang == "en" %}(https://passport.yandex.com/profile/access){% endif %}.

Приложение может отозвать собственный токен, если он был выдан [для определенного устройства](device-token.md).

Все случаи отзыва токенов перечислены на странице [{#T}](../reference/token-invalidate.md).

## Пользовательский интерфейс {#interface}

Страница, на которой пользователь может разрешить доступ приложению ([первый шаг](#step-1) авторизации), содержит название приложения и список запрашиваемых прав:

![image](../../_assets/accept.png)

Когда пользователь нажимает одну из кнопок, OAuth-сервер перенаправляет его на адрес, указанный в качестве [Callback URI](../tasks/register-client.md#web).

