# Получение обезличенных токенов

{% include [login-password-internal-deprecate-single](../../_includes/oauth/reference/internal-tokens/login-password/id-login-password/internal-deprecate-single.md) %}

OAuth-токен, выданный для определенной учетной записи, неудобно использовать в некоторых сценариях серверного взаимодействия. Например, токены могут быть нужны для запроса данных о заблокированных аккаунтах, но получить действующий токен для таких аккаунтов невозможно.

В этом случае можно запрашивать обезличенные токены (см. [описание в спецификации OAuth 2.0](http://tools.ietf.org/html/rfc6749#section-4.4)). Такие токены не привязаны к какой-либо учетной записи и используются только для взаимной авторизации серверных приложений Яндекса.

{% note alert %}

Таким образом рекомендуется выдавать только короткоживущие токены (со временем жизни до 60 секунд), чтобы уменьшить риск для безопасности сервиса. Чтобы ограничить время жизни токенов для новых или существующих прав, напишите в рассылку [oauth@](mailto:oauth@yandex-team.ru).

{% endnote %}

## Аутентификация приложения {#app-auth}

В запросах к {{ service }} следует указывать идентификатор и пароль, которые были сгенерированы при регистрации приложения.

В запросе их можно передать разными способами:

- В заголовке `Authorization`, в строке `<client_id>:<client_secret>`, закодированной методом base64. При этом следует указывать базовый (`Basic`) метод авторизации.
    
  Пример заголовка:
  
  ```no-highlight
  Authorization: Basic NDc2MDE4N2Q4MWJjNGI3Nzk5NDc2YjQycjUxMDM3MTM6ZjI1YmViZjk5MWZmNDE5ODkzZGIyNTU3MjhlNGUxZGU=
  ```

- В теле POST-запроса, в параметрах `client_id` и `client_secret`. Эти параметры обязательно должны передаваться одновременно.
    
Если {{ service }} получает заголовок `Authorization`, параметры `client_id` и `client_secret` в теле запроса игнорируются.

## Формат запроса {#cleartext}

Требования к запросу:

- Запрос токена к Яндекс.OAuth следует отправлять по протоколу HTTPS c помощью метода POST.
    
- ![](../../_assets/code.png)
    
- В каждом запросе токена необходимо передавать реальный IP-адрес пользователя. По умолчанию адресом пользователя считается значение заголовка `Remote-Addr`. Если запрос к Яндекс.OAuth проходит через прокси-сервер или бэкенд, адрес следует передать в параметре `user_ip`.
    
  Проксируемые запросы следует отправлять на специальные OAuth-сервера:
  
  - для боевых внешних сервисов — `oauth-internal.yandex.ru`;
  
  - для боевых внутренних сервисов — `oauth-internal.yandex-team.ru`;
  
  - для релиз-кандидатов — `oauth-rc-internal.yandex.ru`;
  
  - для тестовых версий — на основной адрес, `oauth-test.yandex.ru`.

Формат запроса обезличенного токена:

```no-highlight
POST /token HTTP/1.1
Host: oauth.yandex.ru
X-Forwarded-For: 198.51.100.3
Content-type: application/x-www-form-urlencoded
Content-Length: `<`длина тела запроса`>`
[Authorization: Basic `<`закодированная строка client_id:client_secret`>`]

   grant_type=client_credentials
[& client_id=`<`идентификатор приложения`>`]
[& client_secret=`<`пароль приложения`>`]
[& x_meta=`<`строка`>`]
```

#|
|| **Параметр** | **Описание** ||
|| **Обязательный параметр** ||
|| `grant_type` | Используемый способ запроса токена.

Чтобы получить токен по UID, следует указать значение «client_credentials». ||
|| **Дополнительные параметры** ||
|| `client_id` | Идентификатор приложения. Доступен в [свойствах приложения]{% if lang == "ru" %}(https://oauth.yandex.ru/client/my){% endif %}{% if lang == "en" %}(https://oauth.yandex.com/client/my){% endif %} (нажмите название приложения, чтобы открыть его свойства).

{% include [auth-link](../../_includes/oauth/auth-link.md) %} ||
|| `client_secret` | Пароль приложения. Доступен в [свойствах приложения]{% if lang == "ru" %}(https://oauth.yandex.ru/client/my){% endif %}{% if lang == "en" %}(https://oauth.yandex.com/client/my){% endif %} (нажмите название приложения, чтобы открыть его свойства).
 
{% include [auth-link](../../_includes/oauth/auth-link.md) %} ||
|| `x_meta` | Текстовая строка, которой можно дополнить выданный OAuth-токен. Эта строка возвращается при каждой проверке токена в Черном ящике (метод [oauth](http://doc.yandex-team.ru/blackbox/reference/method-oauth.xml)).

Максимальный размер строки — 65 523 байт. ||
|#

## Формат ответа {#response}

Яндекс.OAuth возвращает ответ в JSON-документе.

{% list tabs %}

- Токен успешно выдан

  Возвращается токен и время его жизни, если оно ограничено:

  ```javascript
  {
    "access_token": "{{ access-token }}",
    "token_type": "bearer",
    "expires_in": 124234123534
  }
  ```

  Ключ | Описание
  ----- | -----
  `access_token` | OAuth-токен с запрошенными правами или с правами, указанными при регистрации приложения.
  `token_type` | Тип выданного токена. Всегда принимает значение <q>bearer</q>.
  `expires_in` | Время жизни токена в секундах. {% if audience == "internal" %}Не включается в ответ для токенов с неограниченным временем жизни.{% endif %}

- Произошла ошибка

  Если запрос выполнить не удалось, то ответ возвращается с HTTP-кодом ошибки и ее описанием:

  ```javascript
  {
    "error_description": "Client not found",
    "error": "invalid_client"
  }
  ```

  Ключ | Описание
  ----- | -----
  `error_description` | Описание ошибки на естественном языке.
  `error` | Код ошибки. Список возможных кодов приведен в таблице ниже.

{% endlist %}

## Поддерживаемые коды ошибок {#error-table}

#|
|| **HTTP-код ответа** | **Код ошибки** | **Описание** ||
|| 400 | invalid_request | Неверный формат запроса (не указан обязательный параметр и т. п.). ||
|| 400 | unsupported_grant_type | Переданное значение параметра `grant_type` не поддерживается. ||
|| 400 или 401 | invalid_client | Возвращается в следующих случаях:
- Приложение с указанным идентификатором не найдено или заблокировано.
- Передан неверный пароль для заданного идентификатора приложения.

HTTP-код ответа 401 возвращается, если идентификатор и пароль приложения были переданы в заголовке `Authorization`. В противном случае возвращается HTTP-код 400. ||
|| 401 | Basic auth required | В заголовке `Authorization` указан тип авторизации, отличный от <q>Basic</q>. ||
|| 401 | Malformed Authorization header | Неверно сформирован заголовок `Authorization`. ||
|| 400 или 401 | unauthorized_client | Приложение еще не одобрено модератором, либо токены для него нельзя получать с указанным значением параметра `grant_type`.

HTTP-код ответа 401 возвращается, если идентификатор и пароль приложения были переданы в заголовке `Authorization`. В противном случае возвращается HTTP-код 400. ||
|#
