# Пользователь вводит код в приложении

Некоторые приложения (например, консольные или установленные на телевизорах Smart TV) не могут [получить код подтверждения из URL](auto-code-client.md). В этом случае пользователь должен самостоятельно получить код от Яндекс.OAuth и ввести его в приложении.

Получение токена в обмен на код, введенный пользователем:

1. Приложение открывает в браузере [страницу {{ service }}](#get-code), где пользователь может разрешить доступ к своим данным.
    
   Если на устройстве, где установлено приложение, недоступен браузер, пользователю придется перейти по нужному адресу на своем компьютере. Чтобы вводить адрес было удобнее, предоставьте пользователю QR-код или короткую ссылку.
    
1. Пользователь переходит на открывшуюся страницу или по короткой ссылке и разрешает доступ приложению.
    
1. {{ service }} выводит код подтверждения (для этого в свойстве приложения **Callback URL** нужно указать адрес `https://oauth.yandex.ru/verification_code`).
    
1. Приложение отправляет [POST-запрос с кодом](#get-token).
    
1. {{ service }} возвращает токен в [теле ответа](#token-body).
    
{% include [web-client-debug](../../_includes/oauth/reference/web-client/id-web-client/debug.md) %}

{% include [web-client-security](../../_includes/oauth/reference/web-client/id-web-client/security.md) %}

## Получение кода подтверждения {#get-code}

1. {% include [web-client-direct](../../_includes/oauth/reference/web-client/id-web-client/direct.md) %}
    
   ```no-highlight
   https://oauth.yandex.ru/authorize?
   response_type=code
   & client_id=<идентификатор приложения>
   [& device_id=<идентификатор устройства>]
   [& device_name=<имя устройства>]
   [& redirect_uri=<адрес перенаправления>]
   [& login_hint=<имя пользователя или электронный адрес>]
   [& scope=<запрашиваемые необходимые права>]
   [& optional_scope=<запрашиваемые опциональные права>]
   [& force_confirm=yes]
   [& state=<произвольная строка>]
   ```
   
   #|
   || **Параметр** | **Описание** ||
   || **Обязательные параметры** ||
   || `response_type` | Требуемый ответ.
   
   При запросе кода подтверждения следует указать значение <q>code</q>. ||
   || `client_id` | Идентификатор приложения. Доступен в [свойствах приложения]{% if lang == "ru" %}(https://oauth.yandex.ru/){% endif %}{% if lang == "en" %}(https://oauth.yandex.com/){% endif %} (нажмите название приложения, чтобы открыть его свойства). ||
   || **Дополнительные параметры** ||
   || `device_id` {#device-id} | Уникальный идентификатор устройства, для которого запрашивается токен. Чтобы обеспечить уникальность, достаточно один раз сгенерировать [UUID]{% if lang == "ru" %}(https://ru.wikipedia.org/wiki/UUID){% endif %}{% if lang == "en" %}(https://en.wikipedia.org/wiki/Universally_unique_identifier){% endif %} и использовать его при каждом запросе нового токена с данного устройства.
   
   {% if audience == "internal" %}
   
   О том, как эти идентификаторы должны получать мобильные приложения Яндекса, читайте на вики: [https://wiki.yandex-team.ru/YandexMobile/Server/AccountsBinding/](https://wiki.yandex-team.ru/YandexMobile/Server/AccountsBinding/).
   
   {% endif %}
   
   Идентификатор должен быть не короче 6 символов и не длиннее 50. Допускается использовать только печатаемые [ASCII]{% if lang == "ru" %}(https://ru.wikipedia.org/wiki/ASCII){% endif %}{% if lang == "en" %}(https://en.wikipedia.org/wiki/ASCII){% endif %}-символы (с кодами от 32 до 126).
   
   {% include [device-token-limit](../../_includes/oauth/concepts/device-token/id-device-token/limit.md) %}
   
   Подробнее о токенах для отдельных устройств читайте на странице [{#T}](../concepts/device-token.md). ||
   || `device_name` | Имя устройства, которое следует показывать пользователям. Не длиннее 100 символов.
   
   Для мобильных устройств рекомендуется передавать имя устройства, заданное пользователем. Если такого имени нет, его можно собрать из модели устройства названия и версии ОС и т. д.
   
   Если параметр `device_name` передан без параметра `device_id`, он будет проигнорирован. {{ service }} сможет выдать только обычный токен, не привязанный к устройству.
   
   Если параметр `device_id` передан без параметра `device_name`, в пользовательском интерфейсе токен будет помечен как выданный для неизвестного устройства. ||
   || `redirect_uri` | URL, на который нужно перенаправить пользователя после того, как он разрешил или отказал приложению в доступе. По умолчанию используется первый Callback URI, указанный в настройках приложения (**Платформы** → **Веб-сервисы** → **Callback URI**).
   
   В значении параметра допустимо указывать только те адреса, которые перечислены в настройках приложения. Если совпадение неточное, параметр игнорируется. ||
   || `login_hint` | Явное указание аккаунта, для которого запрашивается токен. В значении параметра можно передавать логин аккаунта на Яндексе, а также адрес Яндекс.Почты или Яндекс.Почты для домена.
   
   Параметр позволяет помочь пользователю авторизоваться на Яндексе с тем аккаунтом, к которому нужен доступ приложению. Получив параметр, {{ service }} проверяет авторизацию пользователя:
   
   - Если пользователь уже авторизован с нужным аккаунтом, {{ service }} просто запрашивает разрешение на доступ.
   - Если пользователь не авторизован с нужным аккаунтом, он увидит форму входа на Яндекс, в которой поле логина заполнено значением параметра. Помните, что токен не обязательно будет запрошен для указанного аккаунта: пользователь может стереть предзаполненный логин и войти с любым другим.
   
   Если параметр указывает на несуществующий аккаунт, {{ service }} сможет только сообщить об этом пользователю. Приложению придется запрашивать токен заново. ||
   || `scope` | Список необходимых приложению в данный момент прав доступа, разделенных пробелом. Права должны запрашиваться из перечня, определенного при регистрации приложения. Узнать допустимые права можно по ссылке [https://oauth.yandex.ru/client/<client_id>/info](https://oauth.yandex.ru/client/<client_id>/info), указав вместо <client_id> идентификатор приложения.
   
   Если параметры `scope` и `optional_scope` не переданы, то токен будет выдан с правами, указанными при регистрации приложения.
   
   Параметр позволяет получить токен только с теми правами, которые нужны приложению в данный момент.
   
   {% note info %}

   Права доступа, запрошенные одновременно через параметр `scope` и через параметр `optional_scope`, будут считаться опциональными правами, без которых приложение может обойтись. Пользователь самостоятельно решает, какие из запрошенных опциональных прав предоставить, а какие нет.

   {% endnote %} ||
   || `optional_scope` | Список разделенных пробелом опциональных прав доступа, без которых приложение может обойтись. Опциональные права запрашиваются в дополнение к правам, указанным в параметре `scope`. Опциональные права должны запрашиваться из перечня, определенного при регистрации приложения. Узнать допустимые права можно по ссылке [https://oauth.yandex.ru/client/<client_id>/info](https://oauth.yandex.ru/client/<client_id>/info), указав вместо <client_id> идентификатор приложения.

   Если параметры `scope` и `optional_scope` не переданы, то токен будет выдан с правами, указанными при регистрации приложения.

   Пользователь самостоятельно решает, какие из запрошенных опциональных прав предоставить, а какие нет. Токен будет выдан с правами, указанными в параметре `scope`, и правами, выбранными пользователем из указанных в параметре `optional_scope`.

   Параметр можно использовать, например, если приложению нужна электронная почта для регистрации пользователя, а доступ к портрету желателен, но не обязателен.

   {% note info %}

   Права доступа, запрошенные одновременно через параметр `scope` и через параметр `optional_scope`, будут считаться опциональными.

   {% endnote %} ||
   || `force_confirm` | Признак того, что у пользователя обязательно нужно запросить разрешение на доступ к аккаунту (даже если пользователь уже разрешил доступ данному приложению). Получив этот параметр, Яндекс.OAuth предложит пользователю разрешить доступ приложению и выбрать нужный аккаунт Яндекса.

   Параметр полезен, например, если пользователь вошел на сайт с одним аккаунтом Яндекса и хочет переключиться на другой аккаунт. Если параметр не использовать, пользователю придется явно менять аккаунт на каком-нибудь сервисе Яндекса или отзывать токен, выданный сайту.

   Параметр обрабатывается, если для него указано значение <q>yes</q>, <q>true</q> или <q>1</q>. При любом другом значении параметр игнорируется. ||
   || `state` | Строка состояния, которую {{ service }} возвращает без изменения. Максимальная допустимая длина строки — 1024 символа.

   Можно использовать, например, для защиты от [CSRF-атак]{% if lang == "ru" %}(https://ru.wikipedia.org/wiki/Межсайтовая_подделка_запроса){% endif %}{% if lang == "en" %}(https://en.wikipedia.org/wiki/Cross-site_request_forgery){% endif %} или идентификации пользователя, для которого запрашивается токен. ||
   |#
    
1. Когда пользователь разрешает доступ к своим данным, {{ service }} выводит код подтверждения. Время жизни предоставленного кода — 10 минут. По истечении этого времени код нужно запросить заново.

   ![image](../../_assets/code.png)
    
## Обмен кода подтверждения на токен {#get-token}

Приложение отправляет код, а также свой идентификатор и пароль в POST-запросе.

```no-highlight
POST /token HTTP/1.1
Host: oauth.yandex.ru
Content-type: application/x-www-form-urlencoded
Content-Length: <длина тела запроса>
[Authorization: Basic <закодированная строка `client_id:client_secret`>]

   grant_type=authorization_code
 & code=<код подтверждения>
[& client_id=<идентификатор приложения>]
[& client_secret=<пароль приложения>]
[& device_id=<идентификатор устройства>]
[& device_name=<имя устройства>]
```

#|
|| **Параметр** | **Описание** ||
|| **Обязательные параметры** ||
|| `grant_type` | Способ запроса OAuth-токена.

Если вы используете код подтверждения, укажите значение <q>authorization_code</q>. ||
|| `code` | Код подтверждения, полученный от {{ service }}. Время жизни предоставленного кода — 10 минут. По истечении этого времени код нужно запросить заново. ||
|| **Дополнительные параметры** ||
|| `client_id` | Идентификатор приложения. Доступен в [свойствах приложения]{% if lang == "ru" %}(https://oauth.yandex.ru/){% endif %}{% if lang == "en" %}(https://oauth.yandex.com/){% endif %} (нажмите название приложения, чтобы открыть его свойства).

Идентификатор и пароль приложения обязательно нужно передать либо в параметрах запроса, либо в [заголовке Authorization](#auth-header). ||
|| `client_secret` | Пароль приложения. Доступен в [свойствах приложения]{% if lang == "ru" %}(https://oauth.yandex.ru/){% endif %}{% if lang == "en" %}(https://oauth.yandex.com/){% endif %} (нажмите название приложения, чтобы открыть его свойства).

Пароль и идентификатор приложения обязательно нужно передать либо в параметрах запроса, либо в [заголовке Authorization](#auth-header). ||
|| `device_id` | {% include [auto-code-client-device-id-token-p](../../_includes/oauth/reference/auto-code-client/id-auto-code-client/device-id-token-p.md) %}

Если идентификатор был задан в параметре [device_id](#device-id) при запросе кода подтверждения, при запросе токена параметры `device_id` и `device_name` игнорируются. ||
|| `device_name` | Имя устройства, для которого запрашивается токен.

Если при запросе кода подтверждения был передан параметр `device_id`, при запросе токена параметры `device_id` и `device_name` игнорируются. ||
|#

{% include [auto-code-client-auth-header](../../_includes/oauth/reference/auto-code-client/id-auto-code-client/auth-header.md) %}

## Формат ответа с токеном {#token-body}

{{ service }} возвращает OAuth-токен, refresh-токен и время их жизни в JSON-формате:

```javascript
200 OK
Content-type: application/json

{
  "token_type": "bearer",
  "access_token": "{{ access-token }}",
  "expires_in": 124234123534,
  "refresh_token": "{{ refresh-token }}",
  "scope": "login:info login:email login:avatar"
}
```

Свойство | Описание
----- | -----
`token_type` | Тип выданного токена. Всегда принимает значение <q>bearer</q>.
`access_token` | OAuth-токен с запрошенными правами или с правами, указанными при регистрации приложения.
`expires_in` | Время жизни токена в секундах. {% if audience == "internal" %}Не включается в ответ для токенов с неограниченным временем жизни.{% endif %}
`refresh_token` | Токен, который можно использовать для [продления срока жизни](refresh-client.md) соответствующего OAuth-токена.
`scope` | Права, запрошенные разработчиком или указанные при регистрации приложения. Поле `scope` является дополнительным и возвращается, если OAuth предоставил токен с меньшим набором прав, чем было запрошено.

Время жизни refresh-токена совпадает с временем жизни OAuth-токена.

Если выдать токен не удалось, то ответ содержит описание ошибки:

```javascript
{
  "error_description": "<описание ошибки>",
  "error": "<код ошибки>"
}
```

Возможные коды ошибок:

- `authorization_pending` — пользователь еще не ввел код подтверждения.
- `bad_verification_code` — переданное значение параметра `code` не является 7-значным числом.
- `invalid_client` ― приложение с указанным идентификатором (параметр `client_id`) не найдено или заблокировано. Этот код также возвращается, если в параметре `client_secret` передан неверный пароль приложения.
- `invalid_grant` ― неверный или просроченный код подтверждения.
- `invalid_request` ― неверный формат запроса (один из параметров не указан, указан дважды, или передан не в теле запроса).
- `invalid_scope` — права приложения изменились после генерации кода подтверждения.
- `unauthorized_client` — приложение было отклонено при модерации или только ожидает ее.
- `unsupported_grant_type` ― недопустимое значение параметра `grant_type`.
- `Basic auth required` — тип авторизации, указанный в заголовке `Authorization`, отличен от `Basic`.
- `Malformed Authorization header` — заголовок `Authorization` не соответствует формату `<client_id>:<client_secret>`, или эта строка не закодирована методом base64.
