# Токен в обмен на X-токен

{% include [login-password-internal-deprecate-single](../../../_includes/oauth/reference/internal-tokens/login-password/id-login-password/internal-deprecate-single.md) %}

OAuth-токен с правом **Выдача X-Token** (далее просто «X-токен») позволяет получить новый токен для того же аккаунта Яндекса. Этот механизм используется только для мобильных приложений, посредством [Account Manager](https://wiki.yandex-team.ru/yandexmobile/accountmanager).

По умолчанию право **Выдача X-Token** скрыто для всех пользователей {{ service }}. Запросить доступ к нему можно в рассылке [oauth@](mailto:oauth@yandex-team.ru). После этого право можно будет выбрать на странице настроек приложения.

## Аутентификация приложения {#app-auth}

В запросах к {{ service }} следует указывать идентификатор и пароль, которые были сгенерированы при регистрации приложения.

В запросе их можно передать разными способами:

- В заголовке `Authorization`, в строке `<client_id>:<client_secret>`, закодированной методом base64. При этом следует указывать базовый (`Basic`) метод авторизации.
    
  Пример заголовка:
  
  ```no-highlight
  Authorization: Basic NDc2MDE4N2Q4MWJjNGI3Nzk5NDc2YjQycjUxMDM3MTM6ZjI1YmViZjk5MWZmNDE5ODkzZGIyNTU3MjhlNGUxZGU=
  ```
    
- В теле POST-запроса, в параметрах `client_id` и `client_secret`. Эти параметры обязательно должны передаваться одновременно.
    
Если {{ service }} получает заголовок `Authorization`, параметры `client_id` и `client_secret` в теле запроса игнорируются.

## Формат запроса {#cleartext}

Требования к запросу:

- Запрос токена к Яндекс.OAuth следует отправлять по протоколу HTTPS c помощью метода POST.
    
- ![](../../../_assets/code.png)
    
- В каждом запросе токена необходимо передавать реальный IP-адрес пользователя. По умолчанию адресом пользователя считается значение заголовка `Remote-Addr`. Если запрос к Яндекс.OAuth проходит через прокси-сервер или бэкенд, адрес следует передать в параметре `user_ip`.
    
  Проксируемые запросы следует отправлять на специальные OAuth-сервера:
  
  - для боевых внешних сервисов — `oauth-internal.yandex.ru`;
  
  - для боевых внутренних сервисов — `oauth-internal.yandex-team.ru`;
  
  - для релиз-кандидатов — `oauth-rc-internal.yandex.ru`;
  
  - для тестовых версий — на основной адрес, `oauth-test.yandex.ru`.
    
Формат запроса токена в обмен на X-токен:

```no-highlight
POST /token HTTP/1.1
Host: oauth.yandex.ru
X-Forwarded-For: 198.51.100.3
Content-type: application/x-www-form-urlencoded
Content-Length: `<`длина тела запроса`>`
[Authorization: Basic `<`закодированная строка client_id:client_secret`>`]

   grant_type=x-token
 & access-token=`<`X-токен`>`
[& client_id=`<`идентификатор приложения`>`]
[& client_secret=`<`пароль приложения`>`]
[& device_id=<идентификатор устройства>]
[& device_name=<имя устройства>]
[& x_meta=`<`строка`>`]
```

#|
|| **Параметр** | **Описание** ||
|| **Обязательные параметры** ||
|| `grant_type` | Используемый способ запроса токена.

При запросе токена в обмен на X-токен следует указать значение <q>x-token</q>. ||
|| `access-token` | OAuth-токен, позволяющий использовать его для получения других токенов.

Такие токены можно получать только если в настройках приложения выбрано право **Выдача X-Token**. По умолчанию это право скрыто для всех пользователей {{ service }}, запросить доступ к нему можно на рассылке [oauth@](mailto:oauth@yandex-team.ru). ||
|| **Дополнительные параметры** ||
|| `client_id` | Идентификатор приложения. Доступен в [свойствах приложения]{% if lang == "ru" %}(https://oauth.yandex.ru/client/my){% endif %}{% if lang == "en" %}(https://oauth.yandex.com/client/my){% endif %} (нажмите название приложения, чтобы открыть его свойства).

{% include [auth-link](../../../_includes/oauth/auth-link.md) %} ||
|| `client_secret` | Пароль приложения. Доступен в [свойствах приложения]{% if lang == "ru" %}(https://oauth.yandex.ru/client/my){% endif %}{% if lang == "en" %}(https://oauth.yandex.com/client/my){% endif %} (нажмите название приложения, чтобы открыть его свойства).
 
{% include [auth-link](../../../_includes/oauth/auth-link.md) %} ||
|| `device_id` | Уникальный идентификатор устройства, для которого запрашивается токен. Чтобы обеспечить уникальность, достаточно один раз сгенерировать [UUID]{% if lang == "ru" %}(https://ru.wikipedia.org/wiki/UUID){% endif %}{% if lang == "en" %}(https://en.wikipedia.org/wiki/Universally_unique_identifier){% endif %} и использовать его при каждом запросе нового токена с данного устройства.

{% if audience == "internal" %}

О том, как эти идентификаторы должны получать мобильные приложения Яндекса, читайте на вики: [https://wiki.yandex-team.ru/YandexMobile/Server/AccountsBinding/](https://wiki.yandex-team.ru/YandexMobile/Server/AccountsBinding/).

{% endif %}

Идентификатор должен быть не короче 6 символов и не длиннее 50. Допускается использовать только печатаемые [ASCII]{% if lang == "ru" %}(https://ru.wikipedia.org/wiki/ASCII){% endif %}{% if lang == "en" %}(https://en.wikipedia.org/wiki/ASCII){% endif %}-символы (с кодами от 32 до 126).

{% include [device-token-limit](../../../_includes/oauth/concepts/device-token/id-device-token/limit.md) %}

Подробнее о токенах для отдельных устройств читайте на странице [{#T}](../../concepts/device-token.md). ||
|| `device_name` | Имя устройства, которое следует показывать пользователям. Не длиннее 100 символов.

Для мобильных устройств рекомендуется передавать имя устройства, заданное пользователем. Если такого имени нет, его можно собрать из модели устройства, названия и версии ОС и т. д.

Если параметр `device_name` передан без параметра `device_id`, он будет проигнорирован. {{ service }} сможет выдать только обычный токен, не привязанный к устройству.

Если параметр `device_id` передан без параметра `device_name`, в пользовательском интерфейсе токен будет помечен как выданный для неизвестного устройства. ||
|| `x_meta` | Текстовая строка, которой можно дополнить выданный OAuth-токен. Эта строка возвращается при каждой проверке токена в Черном ящике (метод [oauth](http://doc.yandex-team.ru/blackbox/reference/method-oauth.xml)).

Максимальный размер строки — 65 523 байт. ||
|#

## Формат ответа {#response}

Яндекс.OAuth возвращает ответ в JSON-документе.

{% list tabs %}

- Токен успешно выдан

  Возвращается токен и время его жизни, если оно ограничено:

  ```javascript
  {
    "access_token": "{{ access-token }}",
    "token_type": "bearer",
    "expires_in": 124234123534
  }
  ```

  Ключ | Описание
  ----- | -----
  `access_token` | OAuth-токен с запрошенными правами или с правами, указанными при регистрации приложения.
  `token_type` | Тип выданного токена. Всегда принимает значение <q>bearer</q>.
  `expires_in` | Время жизни токена в секундах. {% if audience == "internal" %}Не включается в ответ для токенов с неограниченным временем жизни.{% endif %}

- Произошла ошибка

  Если запрос выполнить не удалось, то ответ возвращается с HTTP-кодом ошибки и ее описанием:

  ```javascript
  {
    "error_description": "Client not found",
    "error": "invalid_client"
  }
  ```

  Ключ | Описание
  ----- | -----
  `error_description` | Описание ошибки на естественном языке.
  `error` | Код ошибки. Список возможных кодов приведен в таблице ниже.

{% endlist %}

## Поддерживаемые коды ошибок {#error-table}

#|
|| **HTTP-код ответа** | **Код ошибки** | **Описание** ||
|| 400 | invalid_request | Неверный формат запроса (не указан обязательный параметр и т. п.). ||
|| 400 | invalid_grant | Переданный OAuth-токен просрочен или не содержит права на выдачу X-токенов. ||
|| 400 | unsupported_grant_type | Переданное значение параметра `grant_type` не поддерживается. ||
|| 400 или 401 | invalid_client | Возвращается в следующих случаях:
- Приложение с указанным идентификатором не найдено или заблокировано.
- Передан неверный пароль для заданного идентификатора приложения.

HTTP-код ответа 401 возвращается, если идентификатор и пароль приложения были переданы в заголовке `Authorization`. В противном случае возвращается HTTP-код 400. ||
|| 401 | Malformed Authorization header | Неверно сформирован заголовок `Authorization`. ||
|| 401 | Basic auth required | В заголовке `Authorization` указан тип авторизации, отличный от <q>Basic</q>. ||
|| 400 или 401 | unauthorized_client | Приложение еще не одобрено модератором, либо токены для него нельзя получать с указанным значением параметра `grant_type`.

HTTP-код ответа 401 возвращается, если идентификатор и пароль приложения были переданы в заголовке `Authorization`. В противном случае возвращается HTTP-код 400. ||
|#
