# Пользователь вводит код на {{ service }}

На некоторых устройствах (например, на телевизорах) вводить код подтверждения может быть неудобно. В этом случае можно предложить пользователю ввести код на странице [Авторизация на устройстве](https://ya.ru/device).

Последовательность получения токена в этом случае:

1. Приложение запрашивает два кода — `device_code` для устройства и `user_code` для пользователя. Время жизни предоставленных кодов — 10 минут. По истечении этого времени коды нужно запросить заново.
    
1. Приложение одновременно:

   - предлагает пользователю ввести `user_code` на странице ;
   - начинает периодически запрашивать OAuth-токен, передавая `device_code`.
    
1. Пользователь вводит правильный код до истечения времени его жизни.
    
1. {{ service }} возвращает токен в ответ на следующий запрос приложения.

{% include [web-client-debug](../../_includes/oauth/reference/web-client/id-web-client/debug.md) %}

{% include [web-client-security](../../_includes/oauth/reference/web-client/id-web-client/security.md) %}

## Запрос кодов подтверждения {#get-codes}

Приложение должно запросить коды подтверждения с помощью HTTP-метода POST

```no-highlight
POST /device/code
Host: oauth.yandex.ru

client_id=<идентификатор приложения>
[& device_id=<идентификатор устройства>]
[& device_name=<имя устройства>]
[& scope=<запрашиваемые необходимые права>]
```

#|
|| **Параметр** | **Описание** ||
|| **Обязательный параметр** ||
|| `client_id` | Идентификатор приложения. Доступен в [свойствах приложения]{% if lang == "ru" %}(https://oauth.yandex.ru/){% endif %}{% if lang == "en" %}(https://oauth.yandex.com/){% endif %} (нажмите название приложения, чтобы открыть его свойства). ||
|| **Дополнительные параметры** ||
|| `device_id` | Уникальный идентификатор устройства, для которого запрашивается токен. Чтобы обеспечить уникальность, достаточно один раз сгенерировать [UUID]{% if lang == "ru" %}(https://ru.wikipedia.org/wiki/UUID){% endif %}{% if lang == "en" %}(https://en.wikipedia.org/wiki/Universally_unique_identifier){% endif %} и использовать его при каждом запросе нового токена с данного устройства.

{% if audience == "internal" %}

О том, как эти идентификаторы должны получать мобильные приложения Яндекса, читайте на вики: [https://wiki.yandex-team.ru/YandexMobile/Server/AccountsBinding/](https://wiki.yandex-team.ru/YandexMobile/Server/AccountsBinding/).

{% endif %}

Идентификатор должен быть не короче 6 символов и не длиннее 50. Допускается использовать только печатаемые [ASCII]{% if lang == "ru" %}(https://ru.wikipedia.org/wiki/ASCII){% endif %}{% if lang == "en" %}(https://en.wikipedia.org/wiki/ASCII){% endif %}-символы (с кодами от 32 до 126).

{% include [device-token-limit](../../_includes/oauth/concepts/device-token/id-device-token/limit.md) %}

Подробнее о токенах для отдельных устройств читайте на странице [{#T}](../concepts/device-token.md). ||
|| `device_name` | Имя устройства, которое следует показывать пользователям. Не длиннее 100 символов.

Для мобильных устройств рекомендуется передавать имя устройства, заданное пользователем. Если такого имени нет, его можно собрать из модели устройства, названия и версии ОС и т. д.

Если параметр `device_name` передан без параметра `device_id`, он будет проигнорирован. {{ service }} сможет выдать только обычный токен, не привязанный к устройству.

Если параметр `device_id` передан без параметра `device_name`, в пользовательском интерфейсе токен будет помечен как выданный для неизвестного устройства. ||
|| `scope` | Список необходимых приложению в данный момент прав доступа, разделенных пробелом. Права должны запрашиваться из перечня, определенного при регистрации приложения. Узнать допустимые права можно по ссылке [https://oauth.yandex.ru/client/<client_id>/info](https://oauth.yandex.ru/client/<client_id>/info), указав вместо <client_id> идентификатор приложения.

Если параметры `scope` и `optional_scope` не переданы, то токен будет выдан с правами, указанными при регистрации приложения.

Параметр позволяет получить токен только с теми правами, которые нужны приложению в данный момент.

{% note info %}

Права доступа, запрошенные одновременно через параметр `scope` и через параметр `optional_scope`, будут считаться опциональными правами, без которых приложение может обойтись. Пользователь самостоятельно решает, какие из запрошенных опциональных прав предоставить, а какие нет.<br/><br/>

{% endnote %} ||
|#

## Ответ с кодами подтверждения {#codes}

{{ service }} возвращает код для пользователя и информацию для запроса токена:

```javascript
HTTP 200 OK

Content-type: application/json

{
  "device_code": "3e2a5a5c0e02439aa78a23442721848c",
  "user_code": "h5nbcr6c",
  "verification_url": "https://oauth.yandex.ru/device",
  "interval": 5,
  "expires_in": 300
}
```

Свойство | Описание
----- | -----
`device_code` | Код, с которым следует запрашивать OAuth-токен на следующем шаге.
`user_code` | Код, который должен ввести пользователь, чтобы разрешить доступ к своим данным.
`verification_url` | Адрес страницы, на которой пользователь должен ввести код из свойства `user_code`.
`interval` | Минимальный интервал, с которым приложение должно запрашивать OAuth-токен. Если запросы будут приходить чаще, Яндекс.OAuth может ответить ошибкой.
`expires_in` | Срок действия пары кодов. По истечению этого срока получить токен для них будет невозможно — нужно будет начать процедуру сначала.

## Ввод кода пользователя {#enter-code}

Пользователь должен ввести код из свойства `user_code` на странице по адресу из свойства `verification_url`. Если код введен корректно, Яндекс.OAuth предложит разрешить или запретить доступ приложению.

Пример такой страницы:

![image](../../_assets/oauth-device.png)

## Запрос токена с кодом устройства {#get-token}

Приложение отправляет код устройства, а также свой идентификатор и пароль в POST-запросе.

```no-highlight
POST /token HTTP/1.1
Host: oauth.yandex.ru
Content-type: application/x-www-form-urlencoded
Content-Length: <длина тела запроса>
[Authorization: Basic <закодированная строка `client_id:client_secret`>]

   grant_type=device_code
   code=<код устройства, полученный предыдущим запросом>
[& client_id=<идентификатор приложения>]
[& client_secret=<пароль приложения>]
```

#|
|| **Параметр** | **Описание** ||
|| **Обязательные параметры** ||
|| `grant_type` | Способ запроса OAuth-токена.

Если вы используете код подтверждения, укажите значение <q>authorization_code</q>. ||
|| `code` | Код подтверждения, полученный от {{ service }}. Время жизни предоставленного кода — 10 минут. По истечении этого времени код нужно запросить заново. ||
|| **Дополнительные параметры** ||
|| `client_id` | Идентификатор приложения. Доступен в [свойствах приложения]{% if lang == "ru" %}(https://oauth.yandex.ru/){% endif %}{% if lang == "en" %}(https://oauth.yandex.com/){% endif %} (нажмите название приложения, чтобы открыть его свойства).

Идентификатор и пароль приложения обязательно нужно передать либо в параметрах запроса, либо в [заголовке Authorization](#auth-header). ||
|| `client_secret` | Пароль приложения. Доступен в [свойствах приложения]{% if lang == "ru" %}(https://oauth.yandex.ru/){% endif %}{% if lang == "en" %}(https://oauth.yandex.com/){% endif %} (нажмите название приложения, чтобы открыть его свойства).

Пароль и идентификатор приложения обязательно нужно передать либо в параметрах запроса, либо в [заголовке Authorization](#auth-header). ||
|#

{% include [auto-code-client-auth-header](../../_includes/oauth/reference/auto-code-client/id-auto-code-client/auth-header.md) %}

## Ответ с OAuth-токеном {#token-body}

{{ service }} возвращает OAuth-токен, refresh-токен и время их жизни в JSON-формате:

```javascript
200 OK
Content-type: application/json

{
  "token_type": "bearer",
  "access_token": "{{ access-token }}",
  "expires_in": 124234123534,
  "refresh_token": "{{ refresh-token }}",
  "scope": "login:info login:email login:avatar"
}
```

Свойство | Описание
----- | -----
`token_type` | Тип выданного токена. Всегда принимает значение <q>bearer</q>.
`access_token` | OAuth-токен с запрошенными правами или с правами, указанными при регистрации приложения.
`expires_in` | Время жизни токена в секундах. {% if audience == "internal" %}Не включается в ответ для токенов с неограниченным временем жизни.{% endif %}
`refresh_token` | Токен, который можно использовать для [продления срока жизни](refresh-client.md) соответствующего OAuth-токена.
`scope` | Права, запрошенные разработчиком или указанные при регистрации приложения. Поле `scope` является дополнительным и возвращается, если OAuth предоставил токен с меньшим набором прав, чем было запрошено.

Время жизни refresh-токена совпадает с временем жизни OAuth-токена.

Если выдать токен не удалось, то ответ содержит описание ошибки:

```javascript
{
  "error_description": "<описание ошибки>",
  "error": "<код ошибки>"
}
```

Возможные коды ошибок:

- `authorization_pending` — пользователь еще не ввел код подтверждения.
- `bad_verification_code` — переданное значение параметра `code` не является 7-значным числом.
- `invalid_client` ― приложение с указанным идентификатором (параметр `client_id`) не найдено или заблокировано. Этот код также возвращается, если в параметре `client_secret` передан неверный пароль приложения.
- `invalid_grant` ― неверный или просроченный код подтверждения.
- `invalid_request` ― неверный формат запроса (один из параметров не указан, указан дважды, или передан не в теле запроса).
- `invalid_scope` — права приложения изменились после генерации кода подтверждения.
- `unauthorized_client` — приложение было отклонено при модерации или только ожидает ее.
- `unsupported_grant_type` ― недопустимое значение параметра `grant_type`.
- `Basic auth required` — тип авторизации, указанный в заголовке `Authorization`, отличен от `Basic`.
- `Malformed Authorization header` — заголовок `Authorization` не соответствует формату `<client_id>:<client_secret>`, или эта строка не закодирована методом base64.
