# Отладочный токен

Работу приложений, которые используют OAuth, можно проверять с помощью отладочных токенов. Их можно получить, открывая [{{ service }}]{% if lang == "ru" %}(https://oauth.yandex.ru/){% endif %}{% if lang == "en" %}(https://oauth.yandex.com){% endif %} в браузере с нужными параметрами. Отладочные токены, как и любые другие, всегда могут быть [отозваны](../reference/token-invalidate.md).

Чтобы получить токен вручную:

1. При [регистрации](../tasks/register-client.md) или редактировании приложения, нажмите ссылку **Подставить URL для разработки** в поле **Платформы** → **Веб-сервисы** → **Callback URI**.

1. Войдите на Яндекс с учетной записью пользователя, к аккаунту которого приложение должно запросить доступ.
1. Перейдите по ссылке следующего вида:

   ```
   https://oauth.yandex.ru/authorize?response_type=token&client_id=<идентификатор приложения>
   ```

   Идентификатор доступен в [свойствах приложения]{% if lang == "ru" %}(https://oauth.yandex.ru/){% endif %}{% if lang == "en" %}(https://oauth.yandex.com/){% endif %} (нажмите на название приложения, чтобы открыть его свойства).

1. Если вы еще не разрешали доступ для этого приложения, или срок жизни выданного токена истек, откроется страница подтверждения доступа. Нажмите кнопку **Разрешить**, чтобы подтвердить выдачу токена.

{{ service }} перенаправит вас на страницу с токеном, добавив данные токена после символа #:

```
https://oauth.yandex.ru/verification_code#
   access_token=<новый OAuth-токен>
 & expires_in=<время жизни токена в секундах>
```

Параметр	| Описание
---- | ----
`access_token`	| OAuth-токен с запрошенными правами или с правами, указанными при регистрации приложения.
`expires_in`	| Время жизни токена в секундах.

Если токен выдать не удалось, то OAuth-сервер добавляет к адресу код ошибки:

```
https://oauth.yandex.ru/verification_code#
  error=<код ошибки>
```

Возможные коды ошибок:

* `access_denied` — пользователь отказал приложению в доступе.
* `unauthorized_client` — приложение было отклонено при модерации или только ожидает ее. Также возвращается, если приложение заблокировано.

## Узнайте больше {#see-also}

* [Процедура авторизации](../concepts/ya-oauth-intro.md#authorization-scheme)
* [Регистрация приложения](../tasks/register-client.md)