# Регистрация приложения

Разработчик приложения должен зарегистрировать его на OAuth-сервере, чтобы получать токены для пользователей Яндекса.

Зарегистрировать приложение можно на странице [Создание приложения]{% if lang == "ru" %}(https://oauth.yandex.ru/client/new){% endif %}{% if lang == "en" %}(https://oauth.yandex.com/client/new){% endif %}. Для каждого приложения обязательно указать только название и доступы. Но чем больше информации о приложении вы предоставите, тем легче пользователям будет понять, кому именно они разрешают доступ к своему аккаунту.

Все приложения, которые вы создали, перечислены в [списке ваших приложений]{% if lang == "ru" %}(https://oauth.yandex.ru/){% endif %}{% if lang == "en" %}(https://oauth.yandex.com){% endif %}.

## Описание приложения {#general}

Название, иконка и набор нужных прав доступа будут отображаться:

- на [странице запроса доступа](../concepts/ya-oauth-intro.md);
- в [списке приложений](https://passport.yandex.ru/profile/access), которым пользователь уже разрешил доступ;
- в [списке ваших приложений]{% if lang == "ru" %}(https://oauth.yandex.ru/){% endif %}{% if lang == "en" %}(https://oauth.yandex.com){% endif %}.

## Платформы {#platform}

Настройки, специфичные для платформ, на которых работает ваше приложение. Например, поле **Callback URI** становится доступно только при выборе опции **Веб-сервисы**.

#|
|| **iOS-приложение** ||
|| **iOS Appid (Prefix + Bundle id)** | Точный идентификатор iOS-приложения, например, `A1B2C3D4E5.com.domain.application`.
Подробнее про идентификаторы iOS-приложений читайте в [документации Apple](https://developer.apple.com/library/content/documentation/General/Conceptual/DevPedia-CocoaCore/AppID.html). ||
|| **iOS AppStore URL** | Ссылка на приложение в AppStore. ||
|| **Android-приложение** ||
|| **Android package name** | Название пакета приложения (поле `applicationId` в файле `build.gradle` вашего модуля).
Подробнее про идентификаторы Android-приложений читайте в [документации Android](https://developer.android.com/studio/build/application-id.html). ||
|| **Android Google Play URL** | Ссылка на приложение в Google Play. ||
|| **SHA256 Fingerprints** | Отпечаток сертификата вашего приложения. О том, как сгенерировать такой отпечаток, читайте в [документации Android](https://developer.android.com/training/app-links/verify-site-associations.html#web-assoc). ||
|| **Веб-сервис** ||
|| **Callback URI** | Адрес, на который пользователь возвращается после того, как он разрешил или отказал приложению в доступе (соответствует параметру `redirect_uri` протокола OAuth).

Вы можете указать несколько адресов **Callback URI** (например, для тестового и боевого окружения). При запросе токена нужный адрес можно задать с помощью параметра `redirect_uri`.

Если вы хотите получать отладочные токены для этого приложения, нажмите ссылку **Подставить URL для разработки**. В поле будет задан тестовый адрес, который позволит [получать отладочные токены вручную](get-oauth-token.md).

{% if audience == "internal" %}

Параметр обязателен, если приложение получает токены, запрашивая разрешение пользователя. При получении токена [другими способами](../reference/resource-owner-credentials.md) параметр не используется.

{% endif %} ||
|#

## Доступы {#scope}

Чтобы выбрать права для вашего приложения, разверните нужные секции и отметьте флажки нужных прав доступа.

В зависимости от выбранных прав могут меняться требования к модерации и время жизни токена (отображаются в блоке **Параметры приложения** внизу страницы).

## Параметры приложения {#params}

В этом блоке отображаются ограничения, которые накладываются на приложения выбранными правами доступа. Например, для API Вебмастера время жизни токена ограничено 180 днями.
