# Спецификация ответов об аккаунтах

В разделе описаны элементы, включаемые в ответы Паспорта об аккаунтах.

Методы [addAccount](addaccount.md), [listAccount](listaccount.md), [editAccount](editaccount.md), [deleteAccount](deleteaccount.md) возвращают ответы в формате XML. Ответы содержат параметры аккаунтов и сведения о результатах выполнения запросов.

## Параметры аккаунтов {#section_h4c_yhk_bbb}

Ниже описаны элементы, содержащие параметры аккаунтов.

#### account

Содержит параметры аккаунта.

#### aliases

Содержит элементы `alias` с синонимами аккаунта, если имеются.

#### alias

Синоним аккаунта. Для добавления синонимов служит метод [addAlias](addalias.md).

#### birth_date

Дата рождения. Не может быть изменена методом [editAccount](editaccount.md), но может изменяться пользователем интерактивно.

#### city

Город проживания пользователя (произвольный формат).

#### country

Страна проживания пользователя (произвольный формат).

#### domain

{% include [accountdef-domain_d](../_includes/api/accountdef/id-accountdef/domain_d.md) %}

#### domain_id

{% include [accountdef-domain_id_d](../_includes/api/accountdef/id-accountdef/domain_id_d.md) %}

#### email

Дополнительный адрес электронной почты.

#### enabled

{% include [accountdef-enabled_d](../_includes/api/accountdef/id-accountdef/enabled_d.md) %}

#### fio

Имя и фамилия пользователя одной строкой. Является автоформируемым параметром и не может быть изменен методом [editAccount](editaccount.md).

#### fname

Фамилия. Если не указана в аккаунте, будет запрошена у пользователя при первой авторизации на портале Яндекса.

#### glogout

Заполняется Паспортом и содержит момент времени (Unix Timestamp), когда пользователь нажал на ссылку **Выйти на всех компьютерах** на странице Паспорта либо когда пользователь сменил пароль. Не может быть изменен методом [editAccount](editaccount.md).

#### hinta

Контрольный вопрос. Если не указан в аккаунте, будет запрошен у пользователя при первой авторизации на портале Яндекса.

#### iname

Ответ на контрольный вопрос. Если не указан в аккаунте, будет запрошен у пользователя при первой авторизации на портале Яндекса.

#### karma

[Карма](https://wiki.yandex-team.ru/Passport/frodo/) пользователя.

#### karma_dead_time

Момент времени, когда пользователь, признанный спамером, должен перестать обслуживаться всеми сервисами. Обычно выставляется сервисом Спамооборона.

#### login

Логин в формате `username@domain`.

#### login_wanted

Для аккаунтов на доменах совпадает с логином. Не может быть изменен методом [editAccount](editaccount.md). Присутствует в силу унификации формата аккаунтов на доменах и обычных аккаунтов.

#### nickname

Псевдоним пользователя. Для ПДД не требуется.

#### passwd

{% include [accountdef-passwd_d](../_includes/api/accountdef/id-accountdef/passwd_d.md) %}

#### regdate

Дата создания аккаунта. Не может быть изменена методом [editAccount](editaccount.md).

#### sex

Пол: 0 — не указан, 1 — мужской, 2 — женский.

#### signed_eula

Признак того, что пользователь принял условия публичной оферты. Не может быть изменен методом [editAccount](editaccount.md).

#### uid

{% include [accountdef-uid_d](../_includes/api/accountdef/id-accountdef/uid_d.md) %}


## Результаты выполнения запросов {#section_j4c_yhk_bbb}

Ниже описаны элементы, содержащие результаты выполнения запросов.

#### errors

Содержит элементы `error`, если при выполнении запроса возникли ошибки. В ответе всегда присутствует элемент errors, даже если ошибок не было.

#### error

Сообщение об ошибке. Ниже перечислены сообщения, общие для всех методов:

* `Field error:err-<name>` — в запросе указан аргумент `<name>` с некорректным форматом значения;
* `Field error:no-<name>` — в запросе отсутствует требуемый аргумент `<name>`;
* `Access denied` — запрашивающая сторона не обладает полномочиями на выполнение запроса;
* `NoTraget` (как написано) — в запросе не указан аргумент `target`;
* `BadTraget` (как написано) — аргумент `target` имеет недопустимое значение;
* `BadOperation` — аргумент `op` имеет недопустимое значение;
* `internal` — ошибка на стороне Паспорта, причина ошибки не уточняется.

#### list

Содержит список доменов с параметрами.

#### result

Содержит значение 'ok', если запрос выполнен без ошибок.

#### operation

Название операции. Совпадает с аргументом op из запроса.

#### target

Название информационного объекта, над которым выполнена операция. Совпадает с аргументом target из запроса.

#### count

Запрос блока записей: содержит количество возвращенных записей.

Запрос по конкретному аккаунту: содержит 1, если он найден, или 0 в противном случае.

#### found

Запрос блока записей: содержит общее количество доменных аккаунтов в Паспорте.

{% note info %}

Чтобы организовать постраничную выборку последовательными запросами, необходимо проверять, возвращены ли данные о последнем аккаунте. Если выполняется условие `start + count = found`, данные о последнем аккаунте присутствуют в ответе.

{% endnote %}

#### start

Запрос блока записей: содержит порядковый номер первой записи в ответе. Нумерация ведется с нуля.

Запрос по конкретному аккаунту: не заполняется.
