# Метод addAccount

Создает аккаунт на подключенном к Почте домене.

Для создания аккаунта достаточно указать логин в формате `user@domain` и пароль. С этими данными пользователь сможет получать и отправлять письма через почтовые программы. Однако при первом интерактивном входе на портал Яндекса у пользователя будут запрошены следующие персональные данные:

- имя (параметр `iname`);
- фамилия (параметр `fname`);
- контрольный вопрос для восстановления пароля (параметр `hinta`);
- ответ на контрольный вопрос (параметр `hintq`);
- подтверждение согласия с условиями публичной оферты (параметр
 `signed_eula`).

{% note info %}

Чтобы избавить пользователя от дорегистрации, необходимо указать имя, фамилию, контрольный вопрос и ответ на него при создании аккаунта или позднее с помощью метода [editAccount](#editAccount). Также необходимо сделать отметку о согласии с условиями публичной оферты, для чего используется метод `admSubscribe` из API Паспорта (в настоящем документе не описан).

{% endnote %}


## Синтаксис запроса {#id1FD91C4A}
```
http://passport-internal.yandex.ru/passport
  ? mode=<mdapi>
  & target=<account>
  & op=<add>
  & login=<user@domain>
  & (passwd=<string> | cryptpasswd=<hash>)
  & [enabled=<0|1>]
  & [weakpass=<0|1>]
  & [changepass=<0|1>]
  & [domain=<URI>]
```
### Параметры
#### mode
*Обязательный параметр*
#### target
*Обязательный параметр*
#### op
*Обязательный параметр*
#### login
*Обязательный параметр*

{% include [accountdef-login_d](../_includes/api/accountdef/id-accountdef/login_d.md) %}


На месте `domain` указывают один из подключенных к Почте доменов, на месте `user` — уникальное имя пользователя в домене.

Допускается не указывать домен, а только имя пользователя, например `petrov.petr`. В этом случае домен необходимо указать в аргументе `domain`.

#### passwd

*Обязательный параметр*

Пароль в открытом виде. Может содержать прописные и строчные буквы английского алфавита, цифры и символы из набора [`-!@#$%^&*()_+`] (не включая угловые скобки).

Вместо открытого пароля можно указать хэш в аргументе `cryptpasswd`.

#### cryptpasswd

*Обязательный параметр*

{% include [accountdef-passwd_d](../_includes/api/accountdef/id-accountdef/passwd_d.md) %}


{% note warning %}

Символы $ и / должны передаваться в url-кодированном виде, то есть заменяться на %24 и %2F соответственно.

{% endnote %}


Вместо хэша можно указать пароль в открытом виде в аргументе `passwd`.

#### enabled

{% include [accountdef-enabled_d](../_includes/api/accountdef/id-accountdef/enabled_d.md) %}


{% note warning %}

Если состояние не указано, аккаунт регистрируется с `enabled` = 0.

{% endnote %}

#### weakpass

Возможность вводить слабые пароли: 0 — слабые пароли запрещены, 1 — слабые пароли разрешены. Аргумент игнорируется, если задан зашифрованный пароль.

Если слабые пароли запрещены, невозможно зарегистрировать пользователя с паролем короче 6 и длиннее 20 символов. Также не допускается совпадение пароля с логином.

{% note info %}

Если слабые пароли разрешены и задан слабый пароль, при первом интерактивном входе на портал Яндекса пользователю будет предложено изменить пароль.

{% endnote %}

#### changepass

Требование сменить пароль: 0 — смена не требуется, 1 — пользователь должен сменить пароль при первой авторизации на портале Яндекса.

#### domain

Имя домена, которому принадлежит аккаунт. Аргумент является обязательным, если домен не указан в аргументе `login`.

Кроме указанных аргументов в запросе на добавление аккаунта могут присутствовать следующие аргументы:

#### city

Город проживания пользователя (произвольный формат).

#### country

Страна проживания пользователя (произвольный формат).

#### email

Дополнительный адрес электронной почты.

#### fname

Фамилия. Если не указана в аккаунте, будет запрошена у пользователя при первой авторизации на портале Яндекса.

#### hinta

Контрольный вопрос. Если не указан в аккаунте, будет запрошен у пользователя при первой авторизации на портале Яндекса.

#### hintq

Ответ на контрольный вопрос. Если не указан в аккаунте, будет запрошен у пользователя при первой авторизации на портале Яндекса.

#### iname

Имя пользователя. Если не указано в аккаунте, будет запрошено у пользователя при первой авторизации на портале Яндекса.

#### nickname

Псевдоним пользователя. Для ПДД не требуется.

#### sex

Пол: 0 — не указан, 1 — мужской, 2 — женский.

> # Пример
> `http://passport-internal.yandex.ru/passport`
> `?mode=mdapi&target=account&op=add&login=petrov.petr@okna.ru&passwd=123&weakpass=1&changepass=1&enabled=1`
> Запрос регистрирует аккаунт `petrov.petr@okna.ru`. Для пользователя задается слабый пароль, а также требование изменить его при первой авторизации на портале Яндекса.

## Формат ответа {#section_yvw_jhk_bbb}

Ответом является XML-структура с параметрами аккаунта.

```xml
<?xml version="1.0" encoding="utf-8"?>
<mdapi>
  <errors> </errors>
  <list>
    <account>
      <aliases> </aliases>
      <birth_date></birth_date>
      <city></city>
      <country></country>
      <domain>okna.ru</domain>
      <domain_id>1</domain_id>
      <email></email>
      <enabled>1</enabled>
      <fio> </fio>
      <fname></fname>
      <glogout>1</glogout>
      <hinta></hinta>
      <hintq></hintq>
      <iname></iname>
      <karma>0</karma>
      <karma_dead_time>0</karma_dead_time>
      <login>petrov.petr@okna.ru</login>
      <login_wanted>petrov.petr@okna.ru</login_wanted>
      <nickname></nickname>
      <passwd>$1$/l4X7BAs$wbF4ox4Wae/Am01x5wsbx.</passwd>
      <regdate>2010-09-16 15:21:07</regdate>
      <sex></sex>
      <signed_eula>0</signed_eula>
      <uid>1130000000000739</uid>
    </account>
  </list>
  <target>account</target>
</mdapi>
```

В элементе `uid` возвращается идентификатор пользователя, присвоенный Паспортом. Для аккаунтов на доменах зарезервированы идентификаторы, начиная с 113*10.

Описание других элементов ответа приведено в разделе [Спецификация ответов об аккаунтах](accountdef.md).

## Сообщения об ошибках {#section_zvw_jhk_bbb}

Для проверки ошибок необходимо выяснить наличие элементов `error` в элементе `errors`. Ниже показан пример сообщения об ошибке.

```xml
<?xml version="1.0" encoding="utf-8"?>
<mdapi>
  <errors>
    <error>unknown-domain</error>
  </errors>
  <target>account</target>
</mdapi>
```
#### errors

Содержит элементы `error`, если при выполнении запроса возникли ошибки. В ответе всегда присутствует элемент errors, даже если ошибок не было.

#### error

Сообщение об ошибке. Ниже перечислены сообщения, общие для всех методов:

* `Field error:err-<name>` — в запросе указан аргумент `<name>` с некорректным форматом значения;
* `Field error:no-<name>` — в запросе отсутствует требуемый аргумент `<name>`;
* `Access denied` — запрашивающая сторона не обладает полномочиями на выполнение запроса;
* `NoTraget` (как написано) — в запросе не указан аргумент `target`;
* `BadTraget` (как написано) — аргумент `target` имеет недопустимое значение;
* `BadOperation` — аргумент `op` имеет недопустимое значение;
* `internal` — ошибка на стороне Паспорта, причина ошибки не уточняется.

Для метода [addAccount](addaccount.md) также предусмотрены следующие сообщения:
* `no-domain` — не указан домен;
* `unknown-domain` — домен с указанным именем не найден или произошла ошибка в во время поиска;
* `unknown-domain-id` — домен с указанным идентификатором не найден или произошла ошибка в во время поиска;
* `domain-unumbigious` — указанны разные имена домена в аргументе `login` и `domain`.
* `domain-is-alias` — указанный домен является синонимом другого домена (у синонимов не может быть аккаунтов);
* `getting domain info failed` — домен найден, но не удалось получить его параметры;
* `badlogin` — неверные символы в логине;
* `occupied` — аккаунт с указанным логином уже существует на домене;
* `no-passwd_cryptpassw` — не указан пароль;
* `passwd-badpasswd` — неверные символы в пароле или пароль совпадает с логином (не проверяется при `weakpass` = 1);
* `passwd-tooshort` — пароль короче допустимого (не проверяется при `weakpass` = 1);
* `passwd-toolong` — пароль длиннее допустимого (не проверяется при `weakpass` = 1).
* `cant_force_change_password` — не удалось установить отметку о необходимости смены пароля у аккаунта;
* `cant_create_mail` — не удалось связать аккаунт с почтовой базой (прием писем для аккаунта невозможен);
* `cant_create_account` — не удалось создать аккаунт из-за внутренних причин Паспорта;
* `log_error` — не удалось сделать запись об операции в журнал логирования.
