# Метод deleteAccount

Удаляет аккаунт.

## Синтаксис запроса {#id2011D8D3}
```
http://passport-internal.yandex.ru/passport
  ? mode=<mdapi>
  & target=<account>
  & op=<delete>
  & (uid=<id> | login=<user@domain>)
  & [drop_account=<1|0>]
```
### Параметры
#### mode
*Обязательный параметр*
#### target
*Обязательный параметр*
#### op
*Обязательный параметр*
#### uid
*Обязательный параметр*

Уникальный идентификатор пользователя.
#### login
*Обязательный параметр*

Логин аккаунта.
#### drop_account

Удалять или блокировать аккаунт: 1 — аккаунт физически удаляется, 0 — аккаунт блокируется, а его подписки удаляются (о подписках см. метод [subscription](subscription.md)).

Если аргумент не указан, подразумевается `drop_account = 0`.

> # Пример
> `http://passport-internal.yandex.ru/passport`
> `?mode=mdapi&target=account&op=delete&uid=1130000000000742&drop_account=1`
> Запрос удаляет аккаунт 1130000000000742.

## Формат ответа {#section_df5_whk_bbb}

Ответом является XML-структура следующего вида.

```xml
<?xml version="1.0" encoding="utf-8"?>
<mdapi>
  <errors> </errors>
  <result>ok</result>
  <target>account</target>
</mdapi>
```

## Сообщения об ошибках {#section_ef5_whk_bbb}

Для проверки ошибок необходимо выяснить наличие элементов `error` в элементе `errors`. Ниже показан пример сообщения об ошибке.

```xml
<?xml version="1.0" encoding="utf-8"?>
<mdapi>
  <errors>
    <error>not found</error>
  </errors>
  <target>account</target>
</mdapi>
```


#### errors

Содержит элементы `error`, если при выполнении запроса возникли ошибки. В ответе всегда присутствует элемент errors, даже если ошибок не было.

#### error

Сообщение об ошибке. Ниже перечислены сообщения, общие для всех методов:

* `Field error:err-<name>` — в запросе указан аргумент `<name>` с некорректным форматом значения;
* `Field error:no-<name>` — в запросе отсутствует требуемый аргумент `<name>`;
* `Access denied` — запрашивающая сторона не обладает полномочиями на выполнение запроса;
* `NoTraget` (как написано) — в запросе не указан аргумент `target`;
* `BadTraget` (как написано) — аргумент `target` имеет недопустимое значение;
* `BadOperation` — аргумент `op` имеет недопустимое значение;
* `internal` — ошибка на стороне Паспорта, причина ошибки не уточняется.
Для метода [deleteAccount](deleteaccount.md) также предусмотрены следующие сообщения об ошибках:
* `not found` — не указан `uid`, или не найден аккаунт, или произошла внутренняя ошибка при получении сведений об аккаунте;
* `has-blocked-services` — аккаунт не может быть удален, поскольку связан с сервисами, препятствующими удалению;
* `delete-error` — ошибка удаления подписок аккаунта при его блокировке или ошибка удаления самого аккаунта;
* `unsubscribe-error` — не удалось удалить подписки аккаунта (дополнительные сведения выводятся в журнал логирования);
* `delete-error` — ошибка удаления аккаунта;
* `delete-error` — невозможно удалить аккаунт, поскольку он используется в качестве catch-all какого-либо домена (ошибка возможна при удалении аккаунта, когда указан аргумент `drop_account`=1, но не появляется при блокировке аккаунта);
* `log-changes-error` — не удалось сделать запись в журнал логирования.
