# Метод deleteHost

Удаляет запись о почтовой базе.

## Синтаксис запроса {#id1FD32C93}
```
http://passport-internal.yandex.ru/passport
  ? mode=<mdapi>
  & target=<host>
  & op=<delete>
  & host_id=<id>
```
### Параметры
#### mode
*Обязательный параметр*
#### target
*Обязательный параметр*
#### op
*Обязательный параметр*
#### host_id
*Обязательный параметр*

{% include [hostdef-host_id_p](../_includes/api/hostdef/id-hostdef/host_id_p.md) %}


> # Пример
> `http://passport-internal.yandex.ru/passport`
> `?op=delete&host_id=18`
> Запрос удаляет запись о почтовой базе с идентификатором 18.

## Сообщения об ошибках {#section_gm4_fwj_bbb}

Для проверки ошибок необходимо выяснить наличие элементов `error` в элементе `errors`. Ниже показан пример сообщения об ошибке.

```xml
<mdapi>
  <errors>
    <error>Delete forbidden yet</error>
  </errors>
  <target>host</target>
</mdapi>
```


#### errors	

Содержит элементы `error`, если при выполнении запроса возникли ошибки. В ответе всегда присутствует элемент errors, даже если ошибок не было.

#### error	

Сообщение об ошибке. Ниже перечислены сообщения, общие для всех методов:

* `Field error:err-<name>` — в запросе указан аргумент `<name>` с некорректным форматом значения;
* `Field error:no-<name>` — в запросе отсутствует требуемый аргумент `<name>`;
* `Access denied` — запрашивающая сторона не обладает полномочиями на выполнение запроса;
* `NoTraget` (как написано) — в запросе не указан аргумент `target`;
* `BadTraget` (как написано) — аргумент `target` имеет недопустимое значение;
* `BadOperation` — аргумент `op` имеет недопустимое значение;
* `internal` — ошибка на стороне Паспорта, причина ошибки не уточняется.
Для метода [deleteHost](deletehost.md) также предусмотрены следующие сообщения:
* `Delete forbidden yet` — невозможно удалить запись о почтовой базе.
