# Спецификация ответов о почтовых базах

В разделе описаны элементы, включаемые в ответы Паспорта о почтовых базах.

Методы [addHost](addhost.md), [listHost](listhost.md), [editHost](edithost.md), [deleteHost](deletehost.md) возвращают ответы в формате XML. Ответы содержат параметры почтовых баз и сведения о результатах выполнения запросов.

## Параметры почтовых баз {#section_c4k_cwj_bbb}

Ниже описаны элементы, содержащие параметры почтовых баз.

#### db_id

Уникальное имя почтовой базы, присвоенное сервисом Почта.

#### host

Содержит вложенные элементы с параметрами почтовой базы.

#### host_id

Идентификатор почтовой базы, присвоенный при регистрации методом [addHost](addhost.md).

#### host_ip

IP-адрес почтового сервера в текстовом формате. В настоящее время не используется.

#### host_name

Имя или псевдоним почтового сервера. В настоящее время не используется.

#### host_number

Идентификатор почтового сервера. В настоящее время не используется.

#### mx

Доменное имя почтового сервера. В настоящее время не используется.

#### prio

Приоритет почтовой базы. С его помощью Почта указывает Паспорту, в какой базе на текущий момент создаются ящики пользователей ПДД. Паспорт считает, что такая база имеет наибольший приоритет после 100.

#### sid

Идентификатор сервиса Почта (sid = 2).

## Результаты выполнения запросов {#section_e4k_cwj_bbb}

Ниже описаны элементы, содержащие результаты выполнения запросов.

#### errors

Содержит элементы `error`, если при выполнении запроса возникли ошибки. В ответе всегда присутствует элемент errors, даже если ошибок не было.

#### error

Сообщение об ошибке. Ниже перечислены сообщения, общие для всех методов:

* `Field error:err-<name>` — в запросе указан аргумент `<name>` с некорректным форматом значения;
* `Field error:no-<name>` — в запросе отсутствует требуемый аргумент `<name>`;
* `Access denied` — запрашивающая сторона не обладает полномочиями на выполнение запроса;
* `NoTraget` (как написано) — в запросе не указан аргумент `target`;
* `BadTraget` (как написано) — аргумент `target` имеет недопустимое значение;
* `BadOperation` — аргумент `op` имеет недопустимое значение;
* `internal` — ошибка на стороне Паспорта, причина ошибки не уточняется.

#### list

Содержит список почтовых баз с параметрами.

#### status

Содержит значение 'ok', если запрос выполнен без ошибок, или 'error' если произошла ошибка.

#### staus

Наличие элемента `staus` (как написано) со значением 'error' говорит об ошибке на стороне Паспорта. Причина ошибки не уточнятся.

#### operation

Название операции. Совпадает с аргументом `op` из запроса.

#### target

Название информационного объекта, над которым выполнена операция. Совпадает с аргументом target из запроса.

#### count

Количество записей о почтовых базах в ответе. Содержит 1, если почтовая база с указанным идентификатором найдена. В противном случае возвращаются записи о всех почтовых базах, а данный элемент содержит количество зарегистрированных в Паспорте баз.

#### found

Совпадает с элементом count, не используется в ответах о почтовых базах.

#### start

Содержит ноль, не используется в ответах о почтовых базах.

{% note info %}

Элементы `found` и `start` присутствуют в силу унификации формата ответов. Эти элементы не несут смысла в ответе метода [listHost](listhost.md), но имеют значение в методах [listDomain](listdomain.md) и [listAccount](listaccount.md).

{% endnote %}
