# Интерфейс взаимодействия

В разделе описан синтаксис запросов HTTP GET для взаимодействия Почты с Паспортом.

В Паспорте реализована информационная модель, в которой необходимые Почте сведения представлены в виде информационных объектов `host` (почтовая база), `domain` (домен), `account` (аккаунт), `subscription` (подписка).

#### `host`

Соответствует почтовой базе, содержит ее имя и параметры.

Почте требуются сведения о почтовых базах при обработке поступивших писем. Почта запрашивает у Паспорта сведения об адресатах, а Паспорт среди прочего возвращает имена почтовых баз, в которых ведутся почтовые ящики адресатов.

Важным параметром почтовой базы является приоритет. С его помощью Паспорту указывают почтовую базу, в которой Почта создает ящики новых пользователей ПДД. Паспорт считает, что эта база имеет наибольший приоритет после 100, и связывает с ней новые аккаунты.

{% note warning %}

В Паспорте должна быть зарегистрирована по меньшей мере одна почтовая база с приоритетом больше 100. В противном случае Паспорт не будет связывать новые аккаунты с почтовыми базами, в результате чего письма не будут доставляться в почтовые ящики этих аккаунтов.

{% endnote %}


#### `domain`

Соответствует домену, подключенному к Почте. Содержит имя домена, `uid` администратора почты этого домена и другие параметры.

#### `account`

Учетная запись пользователя ПДД. Содержит логин, пароль, персональные данные пользователя и служебную информацию.

#### `subscription`

Подписка на сервис. Содержит дополнительный параметр аккаунта, который имеет значение для указанного в подписке сервиса.

Подписки связаны одновременно с аккаунтами и с сервисами. Аккаунт может иметь несколько подписок. Каждая подписка содержит один параметр, имеющий значение для соответствующего сервиса. Например, с помощью подписки аккаунт связан с почтовой базой.

Почта может манипулировать указанными объектами, вызывая методы Паспорта с помощью запросов HTTP GET.

Для вызова методов Паспорта необходимы полномочия, которые предоставляются службой администраторов Паспорта в установленном порядке (рассылка [passport-admin@yandex-team.ru](mailto:passport-admin@yandex-team.ru)).

