# Сценарии регистрации

Сценарий регистрации — это процесс, в результате которого создается новая учетная запись Яндекса. В API Паспорта каждому сценарию соответствует определенная совокупность методов API. Вызывая их в соответствии с описанным алгоритмом, вы гарантированно корректно зарегистрируете пользователя.

{% note info %}

Атрибуты созданного аккаунта и способ авторизации зависят от сценария. Например, [мобильный аккаунт](mobile-registration.md) не может быть авторизован на портале.

{% endnote %}


Описанные в данном документе сценарии:

- [Веб-регистрация с номером телефона](web-registration-phone.md) (с частным случаем включения цифрового логина, `digitsreg`) — регистрация, при которой пользователь обязательно подтверждает номер телефона.
    
- [Веб-регистрация с телефоном или контрольным вопросом](web-registration-alt.md) — пользователь выбирает один из вариантов дополнительной защиты аккаунта.
    
- [Регистрация в мобильном приложении](mobile-registration.md) — регистрация мобильного аккаунта, который может быть авторизован только посредством OAuth-токена для мобильного приложения.
    
- [Двухэтапная регистрация для ритейлеров](retail-registration.md) — двухэтапная регистрация обычного аккаунта Яндекса на продаваемых в розницу телефонах. Продавец создает аккаунт, настраивая аппарат, а пользователь потом активирует аккаунт, подтверждая номер телефона и задавая пароль.
    

Методы, включенные в эти сценарии, можно классифицировать по этапам регистрации:

1. **Подготовка**
    
    Создание трека регистрации и сбор предварительной информации о пользователе (IP-адрес, страна и т. д.).
    
1. **Обработка ввода**
    
    Получение и анализ данных, которые вводит пользователь (логин, пароль, имя и фамилия и т. п.).
    
    API Паспорта позволяет облегчить ввод (например, предлагать незанятые логины) и проверить введенные пользователем данные — найти запрещенные символы, сверить формат телефонного номера и т. д.
    
1. **Завершение**
    
    Создание аккаунта и авторизация пользователя.
    

