# Яндекс.Паспорт

Внешним пользователям Яндекс.Паспорт позволяет управлять своими аккаунтами — регистрировать, изменять личные данные, привязывать номера телефонов и т. д. Внутри Яндекса сервис предоставляет программный доступ к аккаунтам пользователей.

Для взаимодействия с сервисом предусмотрено несколько интерфейсов: веб-интерфейс, программный интерфейс (бэкенд) и МДА, который обеспечивает [мультидоменную авторизацию](https://doc.yandex-team.ru/Passport/AuthDevGuide/concepts/MDA_About.html).

![passport](../_assets/passport.png "Паспорт")

## Веб-интерфейс {#web}

Интерфейс, доступный по адресу `passport.yandex.<tld>`. Позволяет зарегистрировать и удалить аккаунт, авторизоваться и отозвать все авторизационные куки, а также изменить настройки учетной записи и хранимые Паспортом личные данные. Некоторые функции (смена контрольного вопроса, блокировка аккаунта и т. п.) выделены в «режимы», которые описаны в документе [Яндекс.Паспорт. Режимы паспорта](https://doc.yandex-team.ru/Passport/passport-modes/concepts/about.html).

Также веб-интерфейс Паспорта обслуживает `oauth.yandex.<tld>`, где разработчики могут регистрировать и изменять OAuth-приложения, а пользователи — управлять доступом приложений к своему аккаунту.


## Внутренний API Паспорта {#backend}

Внутренний API используется веб-интерфейсом Паспорта, чтобы обрабатывать запросы, полученные от пользователей, а также предоставляет сервисам Яндекса доступ к управлению аккаунтами и служебным функциям, например:

- автоматическая регистрация аккаунтов различных видов;
    
- запрос и установка аватаров;
    
- запрос контрольного вопроса и проверка ответа, введенного пользователем.
    

Список всех доступных функций и документация API приведены на вики: [https://wiki.yandex-team.ru/passport/api](https://wiki.yandex-team.ru/passport/api).


## Мультидоменная авторизация {#mda}

Система, которая позволяет обеспечивать синхронизацию кук пользователей Яндекса между различными доменами.

На практике МДА используется только в доменах РУБК. Все публичные веб-сервисы Яндекса в этих доменах должны поддерживать сквозную авторизацию: пользователь, авторизованный на странице `*.yandex.ru` должен быть также авторизован на странице `*.yandex.ua`.

Механизм сквозной авторизации и требования к сервисам подробно описаны в разделе [Мультидоменная авторизация](https://doc.yandex-team.ru/Passport/AuthDevGuide/concepts/MDA_About.html).

