# Остальные компоненты

В этом разделе собраны компоненты системы авторизации, описание которых коротко или еще предстоит детализировать.


## Email-валидатор {#email}

Сервис, предназначенный для управления email-адресами: пользователи могут привязывать произвольные адреса электронной почты к своему аккаунту, например, чтобы восстанавливать доступ к аккаунту.

![email-validator](../_assets/email-validator.png "Email-валидатор")

Технологии:

- XScript
    
- CORBA
    
- MySQL
    


## Модуль отправки SMS {#sms}

Подсистема, которая помогает сервисам Яндекса отправлять пользователям информационные SMS. Сообщения можно отправлять только на те номера, которые пользователи самостоятельно привязали к своим аккаунтам.

Технологии:

- Perl
    
- MySQL
    


## Черный ящик {#bb}

Внутренний сервис, с помощью которого сервисы Яндекса могут проверять аутентификационные данные (пароли, куки, OAuth-токены), и запрашивать личную информацию о пользователях. API Черного ящика описан в документе [Программный интерфейс сервиса Яндекс.Blackbox. Справочник разработчика](https://doc.yandex-team.ru/blackbox/concepts/about.xml).

Технологии:

- C++
    
- Python
    
- Scala
    
- memcached
    
- Cassandra
    


## tinyurl (укорачиватель ссылок) {#tinyurl}

Внутренний сервис для укорачивания ссылок.

Технологии:

- Python
    
- MySQL
    


## Внешний API Яндекс.Паспорта {#login}

Яндекс.Паспорт помогает любым сайтам и сервисам аутентифицировать пользователя Яндекса с помощью OAuth (и, соответственно, авторизовать без явной регистрации). API задокументирован на сайте Яндекс.Технологий: [https://tech.yandex.ru/passport/](https://tech.yandex.ru/passport/).

Технологии:

- Python
    


## Яндекс.OAuth {#oauth}

Сервис реализует авторизацию на Яндексе по протоколу OAuth 2.0. Обрабатывает запросы от веб-интерфейса Паспорта (который предоставляет графический интерфейс для работы с Яндекс.OAuth).

Документация Яндекс.OAuth различна для внутренних и внешних потребителей: внешнее описание доступно по адресу [https://tech.yandex.ru/oauth/](https://tech.yandex.ru/oauth/), внутренний документ — на портале документации, [OAuth-авторизация. Руководство разработчика](https://doc.yandex-team.ru/oauth/dg/concepts/about.xml).

Технологии:

- Python
    
- MySQL
    
![oauth](../_assets/oauth.png "Яндекс.OAuth")

## Грантушка {#grantushka}

Внутренний сервис, который помогает администраторам Паспорта управлять доступами сервисов и разработчиков Яндекса к программным интерфейсам системы авторизации.

Технологии:

- Python
    
- MySQL
    
![grantushka](../_assets/grantushka.png "Грантушка")

## База данных аккаунтов {#db}

Система авторизации хранит разнообразные данные об аккаунтах и действиях с ними: личные данные, указанные пользователями, логины, пароли, OAuth-токены, история событий и другая служебная информация. Надежность и масштабируемость базы обеспечивается с помощью механизма шардирования, доступного в MySQL.

Технологии:

- MySQL
    


## HistoryDB {#historydb}

Обеспечивает хранение различных логов системы авторизации — информации о произошедших событиях и запросах, обработанных какой-либо подсистемой.

![historydb](../_assets/historydb.png "HistoryDB")

Технологии:

- Python
    
- Scala
    
- HBase
    


## Служебный интерфейс к базам данных {#admin}

Внутренний сервис, который предоставляет визуальный интерфейс для чтения [базы данных аккаунтов](#db) и [HistoryDB](#historydb). Предназначен для сотрудников службы поддержки, службы информационной безопасности и юридического департамента.

Технологии:

- Perl
    
- Python
    
- NodeJS
    

