# admimportreg

Регистрирует новую учетную запись. Режим рекомендуется использовать для создания веб-интерфейса регистрации на стороне сервиса.

{% include [admreg-grant](../_includes/reference/admreg/id-admreg/grant.md) %}


Регистрация в Паспорте может проходить в несколько этапов. Сессия регистрации, объединяющая эти этапы, называется _треком_. Вызовы, относящиеся к одной и той же регистрации, формально связываются идентификатором трека.

Идентификатор трека должен быть указан в каждом следующем запросе к режиму `admimportreg`.


## Формат запроса {#request}

Регистрацию аккаунта с помощью режима `admimportreg` необходимо инициализировать, предварительно получив идентификатор трека. Для этого режим необходимо вызвать без параметров.

```httpget
http://passport-internal.yandex.ru/passport?
mode=admimportreg
```

Получив идентификатор трека, можно вызвать режим `admimportreg` непосредственно для регистрации. Срок жизни идентификатора ограничен 10 минутами.

Параметры `passwd`, `login` и `plogin` необходимо передавать в теле запроса, используя HTTP-метод POST.

```httpget
http://passport-internal.yandex.ru/passport?
mode=admimportreg
& idkey=<идентификатор трека>
& remote_ip=<IP-адрес>
& passwd=<пароль>
& login=<логин> |
  plogin=<логин>
[& iname=<имя>]
[& fname=<фамилия>]
[& hintq=<контрольный вопрос>]
[& hinta=<ответ на контрольный вопрос>]
```
Обязательные параметры
**Параметр:** `mode`

**Значение:** admimportreg

**Описание:** 
Название вызываемого режима.

{% note alert %}

Параметр не должен передаваться в теле запроса.

{% endnote %}



**Параметр:** `idkey`

**Значение:** <пароль>

**Описание:** 
Идентификатор трека, возвращаемый режимом `admimportreg` при запросе без параметров.

При каждом новом вызове режима `admimportreg` параметр должен принимать новое значение, возвращаемое в ответ на предыдущий вызов (см. [формат ответа](#response)).


**Параметр:** `remote_ip`

**Значение:** <IP-адрес>

**Описание:** 
IP-адрес компьютера пользователя, по запросу которого начата регистрация учетной записи.

Указывается в стандартном формате IPv4 (например, 194.84.46.241) или IPv6 (например, 2001:0db8:11a3:09d7:1f34:8a2e:07a0:765d).


**Параметр:** `login`

**Значение:** <логин>

**Описание:** 
Логин для регистрируемой учетной записи.


**Параметр:** `passwd`

**Значение:** <пароль>

**Описание:** 
Пароль для регистрируемой учетной записи.


## Формат ответа {#response}

### Новый идентификатор трека {#idkey-response}

Получен запрос без параметров.

Пример ответа:

```javascript
{
  "idkey":"7FK1293191113upv7krQJs"
}
```

Элемент ответа:

#### idkey
Идентификатор трека, который можно использовать в вызове режима `admimportreg`.

### Успешная регистрация {#success}

Учетная запись успешно создана.

Пример ответа:

```javascript
{
  "uid":"2901231033"
}
```

Элемент ответа:

#### uid
UID созданной учетной записи.

### Ошибка регистрации {#error}

Учетная запись не создана.

Пример ответа:

```javascript
{
  "idkey":"7Fb1293450586fUZT0ElE9",
  "error":"empty_field: passwd,login"
}
```

Элемент ответа:

#### idkey
Идентификатор трека для следующего запроса к `admimportreg` (см. описание параметра [`idkey`](#idkey)).
#### error

Текст возникшей ошибки.

{% include [response-error-table](../_includes/reference/changelang/id-response/error-table.md) %}


Ошибки данных запроса
**Код ошибки:** refresh idkey

**Комментарий:** Идентификатор трека, указанный в значении параметра `idkey`, просрочен.

**Код ошибки:** empty_field: <названия параметров>

**Комментарий:** 
Не заданы некоторые из обязательных полей. Названия пропущенных полей перечислены через запятую.


**Код ошибки:** bad_hintq: noudhint

**Комментарий:** Значение параметра [`hintq`](#hintq) задано неверно.

**Код ошибки:** login occupied

**Комментарий:** Указанный логин занят.

**Код ошибки:** bad_passwd: badpasswd

**Комментарий:** Переданный пароль недостаточно сложный.

**Код ошибки:** bad_passwd: notpost

**Комментарий:** Параметр `passwd` передан не в теле POST-запроса, а в URL.

