# admreg

Регистрирует новую учетную запись. Режим рекомендуется использовать для регистраций с минимальным участием пользователя и для полностью автоматических регистраций (тестовые аккаунты и т. п.).

При первой авторизации с созданной учетной записью пользователь должен сменить пароль (из соображений безопасности Паспорт ограничивает в правах автоматически созданные аккаунты).

Режим предназначен для вызова из внутренних сетей. Для вызова режима необходимо запросить соответствующий грант в [passport-admin@](mailto:passport-admin@yandex-team.ru).


## Формат запроса {#request}

Параметры `login`, `passwd` и `passwd2` необходимо передавать в теле запроса, используя HTTP-метод POST.

```httpget
http://passport-internal.yandex.ru/passport?
mode=admreg
& login=<логин>
& iname=<имя>
& fname=<фамилия>
& passwd=<пароль>
& passwd2=<пароль>
[& from=<короткое название сервиса>]
[& yastaff_login=<login>]
[& ignore_stoplist=1]
[& ena=0]

```

#|
||**Параметр**|**Значение**|**Описание**||
||**Обязательные параметры**| | ||
||`mode`|admreg|
Название вызываемого режима.

{% note alert %}

Параметр не должен передаваться в теле запроса.

{% endnote %}||
||`login`|<логин>|
Логин регистрируемой учетной записи.||
||`iname`|<имя>|
Имя регистрируемого пользователя.||
||`fname`|<фамилия>|
Фамилия регистрируемого пользователя.||
||`passwd`|<пароль>|
Пароль регистрируемой учетной записи.||
||`passwd2`|<пароль>|
Повторно введенный пароль.||
||**Дополнительные параметры**| | ||
||`from`|<короткое название сервиса>|
Короткое название сервиса, на который следует подписать учетную запись при создании.

{% include [request-from-sid](../_includes/reference/register/id-request/from-sid.md) %}


Если значение параметра равно «yastaff», в запросе обязательно должен присутствовать логин сотрудника Яндекса (параметр `yastaff_login`).||
||`yastaff_login`|<логин>|
Логин сотрудника Яндекса, к которому должен быть привязан созданный аккаунт.

Параметр обязателен, если параметр `from` указан со значением «yastaff». Игнорируется при других значениях параметра `from`.||
||`ignore_stoplist`|1|
Признак игнорирования стоп-листа логинов. Если значение аргумента равно «1», и указанный логин свободен, учетная запись будет создана, даже если логин находится в стоп-листе.

Стоп-лист логинов составляется службой поддержки пользователей.||
||`ena`|0|
Признак блокировки учетной записи сразу после регистрации.

Обрабатывается только значение «0» — аккаунт блокируется — остальные значения игнорируются.||
|#


## Формат ответа {#response}

Формат ответа зависит от результата обработки запроса.

[Произведена попытка регистрации](#success)
[Произошла ошибка](#error)


### Произведена попытка регистрации  {#success}

Если указанный логин не занят, учетная запись будет зарегистрирована. В противном случае Паспорт предложит список незанятых логинов.

XML-документ, включающий все элементы, которые могут войти в ответ (в том числе взаимоисключающие):

```xml
<page status="ok" uid="123812933">
    <login>input-login</login>
    <fname>Петечкин</fname>
    <iname>Вася</iname>
    <from>music</from>
    <variants>
        <login>suggest1</login>
        <login>suggest2</login>
    </variants>
</page>
```

Элементы ответа:

#### page
Корневой элемент ответа. Атрибуты элемента:

- **status**
  Статус регистрации. Возможные значения:
  - «occupied» — указанный логин занят. Следует предложить пользователю список незанятых, приведенный в элементе `variants`.
  - «ok» — регистрация успешно завершена, UID новой учетной записи содержится в атрибуте `uid`.

- **uid**
  UID зарегистрированной учетной записи. Включается в ответ только в случае успешной регистрации.
  
Вложенные элементы:
- **login**
  Логин, переданный в запросе.
- **fname**
  Фамилия, переданная в запросе.

- **iname**
  Имя, переданное в запросе.

- **from**
  Короткое название сервиса, переданное в запросе.

- **variants**
  Элемент, содержащий список вариантов логинов. Включается в ответ только если указанный в запросе логин оказался занят.

  - **login**
    Один из вариантов логина, которые можно предложить пользователю.

### Произошла ошибка {#error}

Возвращается ответ с HTTP-кодом 500. В тело ответа включается сообщение об ошибке:

```no-highlight
500: <сообщение об ошибке>
```

Для описания некоторых ошибок режима используется текст интерфейсных ошибок Паспорта. Например, ошибка «Не заполнено одно или несколько полей формы» означает, что в запросе не были заданы обязательные параметры.

