# admsubscribe

Создает или удаляет подписку пользователя на сервис. Для управления подпиской в веб-интерфейсе сервиса следует использовать режимы [subscribe](subscribe.md) (создание подписки) и [unsubscribe](unsubscribe.md) (удаление подписки).

{% note alert %}

Режим `admsubsribe` устарел. Вместо него рекомендуется использовать запросы нового API, предназначенные для [управления подписками](https://wiki.yandex-team.ru/passport/python/api/bundle/managesids).

{% endnote %}


Режим предназначен для ответа на вызовы из внутренних сетей. Для доступа к режиму необходимо запросить грант в [passport-admin@](mailto:passport-admin@yandex-team.ru), указав нужное значение параметра [sid](#sid).


## Формат запроса {#request}

{% include [request-http-get](../_includes/reference/register/id-request/http-get.md) %}


```httpget
http://passport-internal.yandex.ru/passport?
mode=admsubscribe
 & login=<логин>
 | uid=<UID>
 & sid=<SID>
 | from=<короткое название сервиса>
[& unsubscribe=true]
[& yastaff_login=true]
[& wmode=<число>]
```

#|
||**Параметр**|**Значение**|**Описание**||
||**Обязательные параметры**| | ||
||`mode`|admsubscribe|
Название вызываемого режима.

{% note alert %}

Параметр не должен передаваться в теле запроса.

{% endnote %}||
||`uid`|<UID пользователя>|
Идентификатор пользователя в системе авторизации. Рекомендуемый способ идентификации пользователя при вызове `admsubscribe`.||
||`login`|<логин>|
Логин пользователя. Для пользователей ПДД необходимо вместо логина передавать идентификатор пользователя в значении параметра `uid` (передавать электронные адреса режим не позволяет).

Пользователя необходимо идентифицировать, указав один из параметров — `uid` или `login`. Рекомендуется использовать параметр `uid` как более однозначный.||
||**Конфликтующие обязательные параметры**| | ||
||`sid`{#sid}|\<SID\>|Идентификатор сервиса, подписку на который необходимо создать или удалить.||
||`from`|<короткое название сервиса>|
Короткое название сервиса, подписку на который необходимо создать или удалить.

Если параметры `sid` и `from` переданы одновременно, сервис будет идентифицирован по значению `sid`.||
||**Дополнительные параметры**| | ||
||`unsubscribe`|true|
Признак отписки от сервиса.

Обрабатывается только значение «true», которое указывает на вызов `admsubscribe` с целью отписать, а не подписать пользователя.||
||`yastaff_login`|<логин>|
Логин учетной записи на Стаффе, к которой привязывается указанная учетная запись.

Обрабатывается только для значения параметра `sid`, равного «yastaff» или «669».||
||`wmode`|<число>|
Настройки Морды. Используется только для главной страницы.

Обрабатывается только для значения параметра `sid`, равного «wwwdgt».||
|#


## Формат ответа {#response}

Формат XML-ответа зависит от результата обработки запроса. При отсутствии грантов режим возвращает HTML-страницу.

[Запрос успешно обработан](#success)
[Произошла ошибка](#error)


### Запрос успешно обработан {#success}

Корневой элемент `<page>` содержит атрибут `job` со значением «accepted».

Пример ответа:

```xml
<page job="accepted">
  <uid>10176332</uid>
  <sid>2</sid>
  <mode>subscribe</mode>
  <status>nothingtodo</status>
</page>
```

Элементы ответа:

- **uid**
  UID пользователя, подписка которого изменяется.
- **sid**
  Идентификатор сервиса, запросившего изменение подписки.
- **mode**
  Запрошенная операция. Возможные значения:
  - «subscribe» — создание подписки;
  - «unsubscribe» — удаление подписки.

- **status**

  Результат обработки запроса.

  Возможные значения:

  Значение|Комментарий
  --|--
  nothingtodo|Подписка на данный сервис уже находится в запрошенном состоянии, никаких изменений не производилось.
  ok|Изменение подписки выполнено.

### Произошла ошибка {#error}

Корневой элемент `<page>` содержит атрибут `job` со значением «rejected».

Пример ответа:

```xml
<page job="rejected">
  <message>Пользователь с таким UID не найден.</message>
  <error>unknownuid</error>
</page>
```

Элементы ответа:

- **message**
  Сообщение об ошибке.

- **error**
  Код ошибки.

{% include [response-error-table](../_includes/reference/changelang/id-response/error-table.md) %}

#|
||**Код ошибки**|**Комментарий**||
||accountwithloginrequired|Для подписки на сервис необходим логин. Пользователь может задать логин в режиме [postregistration](postregistration.md).||
||accountwithpasswordrequired|Для подписки на сервис необходим пароль. Пользователь может задать пароль в режиме [postregistration](postregistration.md).||
||badsid|Подписка на указанный сервис запрещена для пользователей ПДД.||
||interror|
{% include [response-interror](../_includes/reference/admloginrule/id-response/interror.md) %}||
||nofield|
Не указан обязательный параметр. Имя параметра указано в элементе `message`. Например:

```
<message>uid: Please enter a value</message>
```
||
||occupied|Логин, указанный в значении параметра `yastaff_login`, уже привязан к внешнему логину.||
||unknownlogin|Учетная запись с указанным логином не зарегистрирована.||
||unknownuid|Учетная запись с указанным UID не зарегистрирована.||
|#

