# auth

Позволяет сервисам авторизовать пользователя по логину и паролю, а также позволяет пользователям авторизоваться в Паспорте.

Работа Паспорта зависит от переданных параметров:

1. Если среди параметров запроса нет логина и пароля (параметры `login` и `passwd`), Паспорт выводит [домик авторизации](https://lego.yandex-team.ru/desktop/common/blocks/b-domik).
    
1. Если в запросе указана верная пара логин/пароль, Паспорт выставляет авторизационные куки. После этого пользователь перенаправляется на URL, указанный в параметре `retpath`.
    
    {% note info %}
    
    Перед перенаправлением на `retpath` пользователь может оказаться на промежуточной странице Паспорта (например, для некоторых учетных записей необходимо сменить пароль после авторизации).
    
    {% endnote %}
    
1. Если указана неверная пара логин-пароль, Паспорт также выводит домик авторизации, сообщая об ошибке во введенных данных.
    
    Сообщение выглядит следующим образом:
    
![image](../_assets/auth-wrong.png)

## Формат запроса {#request}

При вызове режима с указанием логина и пароля необходимо использовать HTTP-метод POST. Параметры `login`, `passwd` и `timestamp` следует передавать в теле запроса.

{% note info %}

Устаревший адрес вызова режима: `https://passport.yandex.ru/passport` с обязательным параметром `mode=auth`.

{% endnote %}


```httpget
https://passport.yandex.ru/auth?
[& retpath=<URL>]
[& from=<короткое название сервиса>]
[& twoweeks=<1 | yes>]

[  login=<логин>]
[& passwd=<пароль>]
```

#|
|| **Параметр** | **Значение** | **Описание** ||
|| **Дополнительные параметры** | | ||
|| `retpath` | \<URL\> | Адрес, на который пользователя следует перенаправить после завершения работы режима. Должен указываться в формате URL-encoded.

Если параметр не указан, пользователь перенаправляется на режим [passport](passport.md). ||
|| `from` | <короткое название сервиса> | Короткое название сервиса.

Присваивается сервису при создании [SID](https://docs.yandex-team.ru/authdevguide/concepts/SID_About). ||
|| `twoweeks` |  \<no\> | Указание на то, что пользователю нужно выставить [сессионную куку](https://docs.yandex-team.ru/authdevguide/concepts/authorization-policy-resign). Для этого нужно передать параметр со значением «no» и корректную пару логина и пароля.

Сессионную куку следует выставлять, если пользователь отметил флажок **чужой компьютер** или аналогичным образом указал, что длинная сессия не нужна.

Если параметр не задан, или передан со значением «yes», Паспорт выставляет постоянную куку. ||
|| `login` | \<логин\> | Логин, указанный пользователем.

Должен передаваться в теле POST-запроса. ||
|| `passwd` | \<пароль\> | Пароль, указанный пользователем, в незашифрованном виде.

Должен передаваться в теле POST-запроса. ||
|#

