# Повторный ввод пароля

[Страница доввода пароля](https://passport.yandex.ru/auth/verify) предлагает авторизованному пользователю еще раз ввести пароль, чтобы подтвердить авторизацию. Повторный ввод пароля стоит использовать для защиты важных или необратимых операций с учетной записью (например, при удалении всех данных с сервиса). Это позволит снизить ущерб от кражи авторизационных кук.

Критерии того, что авторизацию нужно подтвердить, сервис определяет сам. Обычно для этого проверяют время, прошедшее с последнего успешного ввода пароля (UNIX-время этого момента можно получить от Черного ящика при [проверке куки Session_id](https://doc.yandex-team.ru/blackbox/reference/method-sessionid-response-json.xml#method-sessionid-response-json), в поле `password_verification_age`).

После того, как пользователь вводит правильный пароль, Паспорт перенаправляет его по ссылке из параметра [retpath](#retpath). Если параметр не передавался, или указанная ссылка ведет на домен, не принадлежащий Яндексу, пользователь будет перенаправлен на [главную страницу Паспорта](https://passport.yandex.ru).


## Формат запроса {#request}

Перенаправлять пользователя на страницу следует следующим образом:

```httpget
https://passport.yandex.TLD/auth/verify
[& retpath=<URL>]
```

#|
||**Параметр** | **Значение** | **Описание**||
||`retpath`{#retpath}|\<URL\>|Адрес, на который пользователя следует перенаправить после завершения работы режима. Должен указываться в формате URL-encoded.

Если параметр не передавался, или указанная ссылка ведет на домен, не принадлежащий Яндексу, пользователь будет перенаправлен на [главную страницу Паспорта](https://passport.yandex.ru).||
|#

