# constructlogin

Составляет список логинов, которые можно предложить пользователю. Предназначен для подготовки к автоматической регистрации в режиме [admimportreg](admimportreg.md).


## Формат запроса {#request}

{% include [request-http-get](../_includes/reference/register/id-request/http-get.md) %}


```httpget
https://passport.yandex.ru/passport?
mode=constructlogin
 & iname=<имя>
 & fname=<фамилия>
 & idkey=<идентификатор трека>
 & lang=<язык>
[& login=<логин>]
[& reqid=<идентификатор запроса>]
```

#|
||**Параметр**|**Значение**|**Описание**||
||**Обязательные параметры**| | ||
||`mode`|constructlogin|
Название вызываемого режима.

{% note alert %}

Параметр не должен передаваться в теле запроса.

{% endnote %}||
||`iname`|<имя>|
Имя пользователя (например, Василий).||
||`fname`|<фамилия>|
Фамилия пользователя (например, Пупкин).||
||`idkey`|<идентификатор трека>|
[Идентификатор трека](admimportreg.md#idkey-explain), возвращаемый режимом [admimportreg](admimportreg.md).||
||`lang`|<язык>|
Идентификатор языка пользователя.

Используемые значения:

- «az» — азербайджанский;
- «be» — белорусский;
- «en» — английский;
- «hy» — армянский;
- «ka» — грузинский;
- «kk» — казахский;
- «ro» — румынский (Молдавия);
- «ru» — русский;
- «tr» — турецкий;
- «tt» — татарский;
- «uk» — украинский.||
||**Дополнительные параметры**| | ||
||`login`|<логин>|
Логин, введенный пользователем.||
||`reqid`|<идентификатор запроса>|
Идентификатор, с помощью которого Паспорт может связать запросы логинов в рамках одной регистрации.

Ответ режима содержит идентификатор в элементе [\<reqid\>](#reqid-response).
|#


## Формат ответа {#response}

Ответ возвращается в виде JSON-документа.

Пример ответа:

```
{
     "input_login":"bobr",
     "input_login_status":"occupied",
     "logins":[
          "bobrov.iwan",
          "bobrov2010",
          "bobrov.vania"
     ],
     "reqid":"15"
}
```

Элементы ответа:

#### input_login
Логин, введенный пользователем. Если логин не был передан в запросе, значение ключа пустое.
#### input_login_status
Статус логина, введенного пользователем. Возможные значения:
- «free» — логин свободен;
- «occupied» — логин занят;
- «error» — ошибка обработки;
- «badlogin_length» — логин слишком длинный или слишком короткий;
- «badlogin» — логин не подходит по другой причине (например, включает слова из стоп-листа).

Если логин не был передан в запросе, значение ключа пустое.

#### logins

Список предлагаемых логинов.

Логины не возвращаются в следующих случаях:

- Паспорт не смог сгенерировать список.
- Превышен лимит вызовов режима `constructlogin` (ограничение накладывается на запросы с одного IP-адреса).

#### reqid{#reqid-response}

Идентификатор запроса.

Идентификатор следует отправить в следующем запросе режима `constructlogin` в рамках данной регистрации (параметр [reqid](#reqid)).

