# embeddedauth

Режим позволяет сервисам авторизовать пользователя по логину и паролю, а также переключать и исключать аккаунты из ранее выданных мультиавторизационных кук (кук `Session_id`, выданных для [нескольких аккаунтов одновременно](https://docs.yandex-team.ru/authdevguide/concepts/multiauth)).

Вид операции, которую совершит режим, зависит от набора переданных параметров:

1. Если присутствует параметр `action` с одним из допустимых значений, считается, что запрошена [операция над мультиавторизационной кукой](#request-multi).
    
1. Если параметра `action` с допустимым значением в запросе нет, считается, что режим вызван для [авторизации пользователя](#request).
    

Результат обработки запроса возвращается в параметрах URL, на который пользователь перенаправляется после завершения работы режима. Если в параметре `retpath` передан некорректный URL или ссылка на домен, не принадлежащий Яндексу, остальные параметры игнорируются, а пользователь перенаправляется на главную страницу Паспорта.


## Операция над мультиавторизационной кукой {#request-multi}

Операция поможет убрать определенный аккаунт из мультиавторизационной куки или сменить основной аккаунт.

Все параметры, кроме `mode`, следует передавать в теле запроса, используя HTTP-метод POST. Переносы строк в примере сделаны только для удобства чтения.

```httpget
POST /passport?mode=embeddedauth HTTP/1.1
Content-Length: 72
Content-Type: application/x-www-form-urlencoded; charset=utf-8
Host: passport.yandex.ru

   uid=000000000
 & action=change_default
 & yu=4978611441401100186
 & retpath=https%3A%2F%2Fmail.yandex.ru
```
#|
||**Параметр** | **Значение** | **Описание**||
||**Обязательные параметры** | |||
||`mode`|register|Название вызываемого режима.

{% note alert %}

Параметр не должен передаваться в теле запроса.

{% endnote %}||
||`action`|\<change_default \| logout\>|Действие, которое нужно произвести над мультиавторизационной кукой.||
||`uid`{#uid}|<UID пользователя>|UID аккаунта, над которым необходимо произвести операцию.||
||`yu`|<кука `yandexuid`>|Текущее значение куки `yandexuid`, выставленной пользователю.||
||`retpath`|\<URL\>|Страница сервиса, обрабатывающая ответы Паспорта на вызов `embeddedauth`.||
||**Дополнительные параметры** | |||
||`idkey`|\<идентификатор трека\>|
Идентификатор сессии авторизации, полученный в ответе на предыдущий запрос.

Не должен указываться в первом запросе `embeddedauth`.

При каждом следующем вызове режима `embeddedauth` в рамках одной сессии параметр должен принимать новое значение, возвращаемое в ответ на предыдущий вызов (см. [формат ответа](#response)).||
||`captcha_answer`|\<текст капчи\>|
Текст капчи, введенный пользователем. Обязателен, если в ответ на предыдущий запрос был получен параметр [captcha_url](#captcha-url).||
||`twoweeks`|\<yes\|1\>|
Указание на то, что пользователю нужно выставить [постоянную куку](https://docs.yandex-team.ru/authdevguide/concepts/authorization-policy-resign). Для этого нужно передать параметр со значением «yes» или «1», а также корректный пару логина и пароля.

Постоянную куку следует выставлять, если пользователь не отметил флажок **чужой компьютер** или аналогичным образом указал, что необходима постоянная авторизация.

Если параметр не задан, или передан с любым другим значением, Паспорт выставляет сессионную куку.||
|#

Если в параметре `retpath` передан некорректный URL или ссылка на домен, не принадлежащий Яндексу, остальные параметры игнорируются, а пользователь перенаправляется на главную страницу Паспорта.


## Запрос авторизации {#request}

Авторизация в Паспорте может проходить в несколько этапов. Сессия авторизации, объединяющая эти этапы, называется _треком_. Вызовы, относящиеся к одной и той же авторизации, формально связываются идентификатором трека.

Идентификатор трека должен быть указан в каждом следующем запросе к режиму `embeddedauth` (например, с текстом капчи, если потребовалось ее запросить).

Все параметры кроме `mode` следует передавать в теле запроса, используя HTTP-метод POST. Переносы строк в примере сделаны только для удобства чтения.

```no-highlight
POST /passport?mode=embeddedauth HTTP/1.1
Content-Length: 72
Content-Type: application/x-www-form-urlencoded; charset=utf-8
Host: passport.yandex.ru

   login=test-user
 & password=test-password
 & retpath=https%3A%2F%2Fmail.yandex.ru
[& idkey=f73c0f4d6e83c5c42553751774c043ce0a]
[& captcha_answer=%D0%BA%D0%B0%D1%83%D1%81%D1%82%D0%B8%D0%BA]
[& twoweeks=no]
```

#|
||**Параметр** | **Значение** | **Описание**||
||**Обязательные параметры** | |||
||`mode`|embeddedauth|Название вызываемого режима.

{% note alert %}

Параметр не должен передаваться в теле запроса.

{% endnote %}||
||`login`{#login}|\<логин\>|Логин, указанный пользователем.||
||`password`{#password}|\<пароль\>|Пароль, введенный пользователем.||
||`retpath`|\<URL\>|Страница сервиса, обрабатывающая ответы Паспорта на вызов `embeddedauth`.

Если в параметре `retpath` передан некорректный URL или ссылка на домен, не принадлежащий Яндексу, остальные параметры игнорируются, а пользователь перенаправляется на главную страницу Паспорта.||
|#


## Формат ответа {#response}

В ответ на вызов режима `embeddedauth` Паспорт всегда перенаправляет браузер пользователя на URL, указанный в параметре `retpath`. Результат авторизации описывается с помощью CGI-параметров в URL.

Используемые параметры:

#### idkey{#idkey}

Идентификатор трека для следующего вызова `embeddedauth`. Передается для всех значений параметра `status`, кроме «ok».

#### url{#url}

Ссылка на Паспорт, на которую следует перенаправить пользователя, если статус авторизации не определен. Передается только если значение параметр `status` принимает значение «other».

#### captcha_url{#captcha-url}

Ссылка на изображение с капчей. Если параметр присутствует в запросе, сервис должен показать капчу пользователю вне зависимости от статуса авторизации.

Пользователю нужно предоставить возможность сменить нечитаемую капчу на новую. Для этого рядом с изображением нужно разместить псевдо-ссылку, загружающую новую капчу. Запрос новой капчи следует посылать по адресу `captcha_url` с добавленными GET-параметрами:

- `cantread` со значением «1»;
- `ncrnd`, в значении — случайное пятизначное число.

#### status

Статус авторизации.

Предполагается, что каждый статус сервис обрабатывает определенным образом. В таблице перечислены возможные значения статуса и ожидаемые действия сервиса.

#|
||**Код статуса** | **Комментарий** | **Действия сервиса**||
||`ok`|Все этапы авторизации пройдены успешно:

- учетная запись с указанным логином найдена;
- переданный пароль корректен;
- пользователю выставлены авторизационные куки;
- МДА сработала.|Показать персонализированную страницу.||
||`account-not-found`|Учетная запись с указанным логином не найдена.|Сообщить пользователю о том, что логин неверен.||
||`action-not-required`|Запрошено переключение на аккаунт, который уже является основным.|
Считать операцию успешной.
||
||`captcha-required`|Для продолжения авторизации пользователь должен ввести капчу.|Показать пользователю капчу. Ссылка на изображение содержится в значении параметра [captcha_url](#captcha-url).||
||`captcha-invalid`|Текст капчи не соответствует изображению, переданному в параметре [captcha_url](#captcha-url) в предыдущем запросе.|
Решить две задачи:

1. Сообщить пользователю о том, что текст капчи введен неверно.
1. Показать новую капчу, используя ссылку в значении параметра [captcha_url](#captcha-url).
||
||`internal-exception`|Внутренняя ошибка Паспорта.|
Вызвать режим еще раз. Для авторизации — не указывая параметр [idkey](#idkey).
||
||`login-empty`|Не указан логин в параметре [login](#login).|
Проверить наличие данных:

- Если пользователь не ввел логин — напомнить об этом обязательном поле.
- Если логин был введен — проверить формирование запроса к Паспорту.
||
||`other`|Ситуация, не относящаяся ни к одному из прочих статусов (например, пользователь должен сменить пароль сразу после авторизации).|
Перенаправить пользователя по ссылке из значения параметра [url](#url).
||
||`password-empty`|Не указан пароль в параметре [password](#password).|
Проверить наличие данных:

- Если пользователь не ввел пароль — напомнить об этом обязательном поле.
- Если пароль был введен — проверить формирование запроса к Паспорту.
||
||`password-invalid`|Переданный пароль неверен.|
Попросить пользователя ввести пароль повторно.
||
||`session-invalid`|У пользователя нет куки `Session_id` правильного формата.|
Авторизовать пользователя.
||
||`session-no-uid`|В куке `Session_id` пользователя нет идентификатора, указанного в параметре [uid](#uid).|
Если нужно было удалить аккаунт из куки, ничего делать не нужно.

Если пользователь хотел переключиться на этот аккаунт, следует предложить авторизоваться им еще раз.
||
||`uid-empty`|Не указан UID в параметре [uid](#uid).|
Указать корректный UID при вызове.||
|#

