# postregistration

Позволяет задать логин и/или пароль для учетной записи, которая может быть авторизована только с [социальным профилем](https://docs.yandex-team.ru/authdevguide/concepts/accounts-attributes#social-profile).

Пользователя следует перенаправить на режим `postregistration`, если авторизация без логина или пароля на сервисе недопустима.


## Формат запроса {#request}

{% include [request-http-get](../_includes/reference/register/id-request/http-get.md) %}


```httpget
https://passport.yandex.ru/passport?
mode=postregistration
[& create_login=1]
[& create_password=1]
[& retpath=<URL>]
```
#|
||**Параметр** | **Значение** | **Описание**||
||**Обязательный параметр** | |||
||`mode`|register|Название вызываемого режима.

{% note alert %}

Параметр не должен передаваться в теле запроса.

{% endnote %}||
||**Дополнительные параметры** | |||
||`create_login`|1| 
Признак необходимости логина.

Обрабатывается только значение «1»: пользователю предлагается форма для ввода логина и скрытая под AJAX-ссылкой форма для ввода пароля. Все значения кроме «1» игнорируются.

Выбрать пароль без логина невозможно. Если в запросе не указаны параметры `create_login` или `create_password`, режим предлагает пользователю задать только логин.||
||`create_password`|1| 
Признак необходимости пароля.

Обрабатывается только значение «1»: пользователю предлагаются формы для ввода логина и пароля (или только пароля, если логин уже задан). Все значения кроме «1» игнорируются.

Выбрать пароль без логина невозможно. Если в запросе не указаны параметры `create_login` или `create_password`, режим предлагает пользователю задать только логин.||
||`retpath`|\<URL\>| 
Адрес, на который пользователя следует перенаправить после завершения работы режима. Должен указываться в формате URL-encoded.

Если параметр не указан, пользователь перенаправляется на режим [passport](passport.md).||
|#

