# register

Предоставляет веб-интерфейс регистрации в Яндексе. Авторизованным пользователям режим предлагает создать новый аккаунт.

Вид формы по умолчанию:

![image](../_assets/register.png)

## Формат запроса {#request}

Режим рекомендуется вызывать с помощью HTTP-метода GET.

```httpget
https://passport.yandex.ru/passport?
mode=register
[& msg=<идентификатор сообщения>]
[& retpath=<URL>]
[& from=<короткое название сервиса>]
[& origin=<идентификатор источника регистрации>]
```

#|
||**Параметр**|**Значение**|**Описание**||
||**Обязательный параметр**| | ||
||`mode`|register|Название вызываемого режима.

{% note alert %}

Параметр не должен передаваться в теле запроса.

{% endnote %}||
||**Дополнительные параметры**| | ||
||`msg`|<идентификатор сообщения>|Идентификатор приветственного сообщения, которое выводится непосредственно над формой регистрации.

Используется только Почтой.||
||`retpath`|\<URL\>|Адрес, на который пользователя следует перенаправить после завершения работы режима. Должен указываться в формате URL-encoded.

Если параметр не указан, пользователь перенаправляется на режим [passport](passport.md).||
||`from`|<короткое название сервиса>|Короткое название сервиса, согласно которому следует оформить интерфейс регистрации.

Короткое название присваивается сервису при создании [SID](https://docs.yandex-team.ru/authdevguide/concepts/SID_About).||
||`origin`|<идентификатор источника регистрации>|Идентификатор способа, которым пользователь попал на регистрацию (например, может указывать на баннер или промо-страницу).

Параметр и его использование подробно освещены в [Вики](http://wiki.yandex-team.ru/passport/statbox/faq) (придумывая новое значение параметра, сверьтесь со [списком используемых значений](http://wiki.yandex-team.ru/Pochta/marketing/originbestiary)).||
|#





