# subscribe

Создает подписку пользователя на сервис, указанный в параметрах запроса.

Поведение Паспорта зависит от состояния подписки и блокировки пользователя на сервисе:

- Пользователь не подписан на сервис — Паспорт добавляет новую запись в таблицу [subscription](https://docs.yandex-team.ru/authdevguide/concepts/DB_About#subscription-table) базы данных системы авторизации.
- Пользователь уже подписан на сервис, но пользоваться сервисом ему запрещено — выводится сообщение «Доступ к сервису заблокирован».
- Пользователь уже подписан на сервис, пользование им разрешено — ничего не происходит.

{% note info %}

Для удаления подписки предназначен режим [unsubscribe](unsubscribe.md).

Для программного добавления и удаления подписки рекомендуется использовать режим [admsubscribe](admsubscribe.md), предназначенный для авторизованных роботов.

{% endnote %}



## Формат запроса {#request}

{% include [request-http-get](../_includes/reference/register/id-request/http-get.md) %}


```httpget
https://passport.yandex.ru/passport?
mode=subscribe
[& from=<короткое название сервиса>]
[& retpath=<URL>]
```

#|
||**Параметр**|**Значение**|**Описание**||
||**Обязательный параметр**| | ||
||`mode`|subscribe|
Название вызываемого режима.

{% note alert %}

Параметр не должен передаваться в теле запроса.

{% endnote %}||
||**Дополнительные параметры**| | ||
||`from`|<короткое название сервиса>|
Короткое название сервиса, на который следует подписать пользователя.

{% include [request-from-sid](../_includes/reference/register/id-request/from-sid.md) %}||
||`retpath`|\<URL\>|
Адрес, на который пользователя следует перенаправить после завершения работы режима. Должен указываться в формате URL-encoded.

Если параметр не указан, пользователь перенаправляется на режим [passport](passport.md).||
|#

