# Брокер

Брокер — это компонент Социализма, который запрашивает у провайдера информацию об аккаунтах соцсетей, принадлежащих пользователям. Для этого Брокер предварительно запрашивает доступ к аккаунтам у владельцев. Предоставленные провайдером данные Брокер может сохранить в новом или имеющемся социальном профиле в [Хранилище](db.md).

Задачи, которые помогает решать Брокер:

* [Запросить информацию об аккаунте](#data) из соцсети.

    Сервис Яндекса должен предоставить пользователю интерфейс Брокера, в попапе или на отдельной странице. В Брокере пользователь может разрешить сервису Яндекса доступ к своему аккаунту соцсети. Если разрешение получено, Брокер запрашивает данные об аккаунте и OAuth-токен (API соцсети затем можно вызывать посредством [Прокси](proxy.md)).

* [Авторизовать пользователя](#auth) на Яндексе с аккаунтом соцсети.

    Сервис Яндекса должен перенаправить пользователя в Паспорт. Паспорт использует Брокер, чтобы получить сведения об аккаунте соцсети, с которым пользователь хочет авторизоваться, и выставляет авторизационные куки.

    {% note info %}

    Нативная авторизация в мобильных приложениях разрабатывается в рамках [Account Manager](https://wiki.yandex-team.ru/yandexmobile/accountmanager).

    {% endnote %}

О результатах работы Брокер сообщает при [обратном перенаправлении на сервис](#start).

## Параметры перенаправления в Брокер {#request}

В интерфейсе Брокера пользователь может дать разрешение на доступ к своему аккаунту, а также авторизоваться на Яндексе. Для этого сервисы Яндекса перенаправляют пользователей в Брокер.

Все запросы к Брокеру можно разделить на две группы:

* Если Брокер должен использовать приложение по умолчанию для данной соцсети, в запросе достаточно указать параметр `provider` с нужным значением.

* Если Брокер должен использовать специфическое приложение соцсети, достаточно указать параметр `application` с нужным значением.

Если задано приложение, не соответствующее указанному провайдеру, Брокер вернет [ошибку](#status). Список поддерживаемых провайдеров, соответствующих им приложений и идентификаторов [приведен на Вики](https://wiki.yandex-team.ru/social/providers).

[Запрос данных из социальной сети](#data)

[Авторизация на веб-сервисе Яндекса](#auth)

[Параметры Брокера](#parameters)

### Запрос данных из социальной сети {#data}

Пользователя можно отправить в Брокер, чтобы получить или актуализировать информацию об аккаунте, которую предоставляет провайдер, а также запросить OAuth-токен с определенными правами.

Брокер может сохранить полученные данные в социальном профиле. Для этого нужно авторизовать пользователя каким-либо образом и при вызове Брокера передать параметр `bind`.

{% note info %}

По умолчанию Брокер сохраняет полученные данные во временной базе данных. В течение трех часов после этого можно запросить эти данные, создать на их основе новый социальный профиль или обновить существующий. Формат этих запросов [описан в Вики](https://wiki.yandex-team.ru/social/api#rabotastaskamisocialnogobrokera).

{% endnote %}

Формат редиректа в Брокер (таблица с описанием параметров [приведена ниже](#parameters)):

```no-highlight
Host: <один из хостов Социализма>

GET /broker2/start?
   (provider=<идентификатор провайдера> | application=<идентификатор приложения>)
 & consumer=<идентификатор сервиса>
 & retpath=<URL для возврата на сервис>
[& scope=<набор дополнительных прав для OAuth-токена>]
[& bind=0]
[& return_brief_profile=0]
[& place=<query | fragment>]
[& yandex_token=<OAuth-токен Яндекса>]
[& display=<page | popup | touch | wap>]
```

### Авторизация на веб-сервисе Яндекса {#auth}

Процесс авторизации через провайдера проходит в несколько этапов:

1. Сервис отправляет пользователя в Яндекс.Паспорт, указав параметры авторизации.

1. Паспорт перенаправляет пользователя в Брокер с полученными от сервиса параметрами.

1. В интерфейсе Брокера пользователь выбирает параметры авторизации: с каким именно аккаунтом входить, привязывать ли аккаунт соцсети к текущему аккаунту Яндекса и т. д.

1. После того, как Брокер завершает работу, пользователь возвращается в Паспорт, где получает или не получает авторизационные куки.

1. Паспорт возвращает пользователя на сервис, передавая ответ Брокера в параметрах редиректа.

Таким образом, сервис должен только правильно составить первоначальный запрос и обработать ответ Брокера. При перенаправлении в Паспорт следует использовать те же параметры, что и при запросе данных у соцсети. Отличается только хост редиректа: авторизационные куки выставляются только в Паспорте.

Формат редиректа в Паспорт (таблица с описанием параметров [приведена ниже](#parameters)):

```no-highlight
Host: passport.yandex.ru

GET /auth/social/start/?
   (provider=<идентификатор провайдера> | application=<идентификатор приложения>)
 & consumer=<идентификатор сервиса>
 & retpath=<URL для возврата на сервис>
[& scope=<набор дополнительных прав для OAuth-токена>]
[& return_brief_profile=0]
[& place=<query | fragment>]
[& yandex_token=<OAuth-токен Яндекса>]
[& display=<page | popup | touch | wap>]
```

### Параметры Брокера {#parameters}

В таблице перечислены все параметры, которые можно передать Брокеру:

**Обязательные параметры**

Параметр | Описание
:--- | :---
`provider` | Идентификатор провайдера.<br/><br/>Брокер обратится к соцсети через приложение по умолчанию для данного провайдера. Список поддерживаемых провайдеров, соответствующих им приложений и идентификаторов [приведен на Вики](https://wiki.yandex-team.ru/social/providers).<br/><br/>В запросе должен быть передан хотя бы один из параметров `provider` и `application`, но их не следует передавать одновременно. Если задано приложение, не соответствующее указанному провайдеру, Брокер вернет [ошибку](#status).
`application` | Идентификатор приложения соцсети, которое должен использовать Брокер. Зарегистрированные для Яндекса приложения [перечислены на Вики](https://wiki.yandex-team.ru/social/providers).<br/><br/>В запросе должен быть передан хотя бы один из параметров `provider` и `application`, но их не следует передавать одновременно. Если задано приложение, не соответствующее указанному провайдеру, Брокер вернет [ошибку](#status).
`consumer` | Идентификатор сервиса, который отправляет пользователя в Брокер.<br/><br/>Этот идентификатор необходим для диагностики и статистики — чтобы Социализм мог опознать запросы от определенного сервиса. Можно использовать короткое имя сервиса, например «mail» или «fotki» (специально регистрировать выбранный идентификатор не нужно).
`retpath` | URL для возврата на сервис после того, как пользователь завершил работу с Брокером.<br/><br/>Домен второго уровня в указанном URL должен принадлежать Яндексу, иначе Брокер ответит [ошибкой](#status). Если домен определенно принадлежит Яндексу, но Брокер его отвергает, напишите об этом в рассылку [social-dev@](social-dev@yandex-team.ru).

**Дополнительные параметры**

Параметр | Описание
:--- | :---
`scope` | Права нужного OAuth-токена.<br/><br/>Следует использовать идентификаторы прав, указанные в документации провайдера. Несколько идентификаторов можно указать, разделив их запятыми.
`bind` {#bind} | Признак привязки данных, полученных от соцсети, к аккаунту в Яндексе.<br/><br/>Поддерживаемые значения:<br/><br/>- «0» — значение по умолчанию. Брокер перенаправляет пользователя в соцсеть, получает данные и сохраняет их во временном хранилище. Новый социальный профиль не создается, имеющийся не обновляется.<br/><br/>- «1» — Брокер проверяет авторизацию пользователя на Яндексе и возвращает [ошибку](#status), если пользователь не авторизован.<br/><br/>    Если пользователь авторизован, Брокер перенаправит его в соцсеть, получит нужные данные и создаст или обновит соответствующий социальный профиль в [Хранилище](db.md).
`return_brief_profile` {#return_brief_profile} | Требование добавить в ответ Брокера идентификатор социального профиля, который был создан или обновлен при обработке запроса. По этому идентификатору данные профиля можно получить в [Хранилище](db.md).<br/><br/>Поддерживаемые значения:<br/><br/>- «0» — значение по умолчанию, ответ Брокера дополнять не нужно.<br/><br/>- «1» — в ответ Брокера нужно включить идентификатор социального профиля.<br/><br/>При запросе данных из соцсети этот параметр стоит передавать, только если также передан параметр `bind` со значением «1». Иначе никаких изменений в профилях не произойдет.
`place` {#place} | Оформление ответа Брокера в адресе обратного редиректа.<br/><br/>Поддерживаемые значения:<br/><br/>- «query» — значение по умолчанию. Ответ возвращается в query-параметрах адреса (после знака `?`).<br/><br/>- «fragment» — ответ возвращается в параметрах, заключенных в хэше адреса (после знака `#`).
`yandex_token` | Токен, выданный сервисом Яндекс.OAuth.<br/><br/>Если параметр передан, токен используется для проверки авторизации пользователя вместо авторизационных кук.
`display` | Тип страницы Брокера, которую следует показать пользователю.<br/><br/>Поддерживаемые значения:<br/><br/>- «popup» — значение по умолчанию. Страница Брокера открывается в попап-окне.<br/><br/>- «page» — полноразмерная страница.<br/><br/>- «touch» — мобильная верстка.<br/><br/>- «wap» — мобильная верстка предыдущего поколения.

## Формат ответа Брокера {#start}

Брокер возвращает результаты своей работы в URL при перенаправлении пользователя обратно на сервис. В зависимости от параметра [place](#place) в исходном редиректе, ответ оформляется в query-параметрах или в хэше URL.

Примеры ответов Брокера:

```no-highlight
# ответ с query-параметрами
https://service.yandex.ru/**?status=ok&task_id=231123&profile.profile_id=6371525**

# ответ в хэше URL
https://service.yandex.ru/?landing=promo**#status=error**
```

Возможные элементы ответа: {#status}

Параметр | Описание
----- | -----
`status` | Общий статус операции. Возможные значения:<br/><br/>- «ok» — Брокер получил от провайдера все запрошенные данные и записал их в базу данных.<br/><br/>- «error» — Брокеру по какой-то причине не удалось получить данные от провайдера.<br/><br/>Брокер возвращает ошибку в следующих случаях:<br/><br/>- пользователь отказал в запрошенном доступе;<br/><br/>- сервис неверно сформировал URL перенаправления в Брокер;<br/><br/>- у Брокера или провайдера возникли технические проблемы.<br/><br/>Технические проблемы пользователя Брокер помогает решить, предлагая в интерфейсе возможность повторить неудавшееся действие.
`task_id` | Идентификатор операции Брокера.<br/><br/>Этот идентификатор можно использовать в [вызовах API Паспорта](https://wiki.yandex-team.ru/social/api#rabotastaskamisocialnogobrokera), предназначенных для работы с временным хранилищем Социализма.
`profile.profile_id` | Идентификатор социального профиля, который был создан или изменен в процессе работы Брокера.<br/><br/>Возвращается, только если в исходном редиректе были заданы параметры [bind](#bind) и [return_brief_profile](#return_brief_profile), оба со значением «1».
