# Общие сведения

Социализм предоставляет сервисам Яндекса унифицированный интерфейс для обращения к социальным сетям и полученным от них данным.

С помощью Социализма сервисы могут:

* получать данные об аккаунтах соцсетей и привязывать эти аккаунты к учетным записям Яндекса;
    
* авторизовывать пользователей социальных сетей;
    
* использовать функции поддерживаемых соцсетей (ставить лайки, публиковать посты и т. п.) с помощью унифицированного прокси-сервера.
    
Социальная сеть, предоставляющая данные о своих аккаунтах, является [провайдером](#provider). Связь между учетной записью Яндекса и аккаунтом провайдера, зафиксированная Социализмом, называется [социальным профилем](#profile).

[Компоненты Социализма](#purpose) помогают сервисам решать задачи взаимодействия с провайдерами и обработки социальных профилей.

[Провайдеры](#provider)

[Социальный профиль](#profile)

[Компоненты Социализма](#purpose)

## Провайдеры {#provider}

Социальные сети, с которыми можно работать с помощью Социализма, называются провайдерами. Чтобы правильно транслировать запросы к соцсетям, компонентам Социализма необходимы идентификаторы провайдеров или созданных у провайдеров приложений.

Социализм обращается к каждому провайдеру посредством приложений, зарегистрированных в этой социальной сети. Для разных задач можно использовать различные приложения. Например, Яндекс.Браузер использует отдельное приложение Facebook, чтобы отслеживать оповещения (запросы на добавление в друзья, новые сообщения и т. п.).

Доступные провайдеры, их особенности и приложения соцсетей, принадлежащие Яндексу, [приведены на Вики](https://wiki.yandex-team.ru/social/providers).

{% note info %}

С любыми вопросами о приложениях обращайтесь в рассылку [social-dev@](mailto:social-dev@yandex-team.ru).

{% endnote %}

## Социальный профиль {#profile}

Социальным профилем называется связь между учетной записью Яндекса и аккаунтом провайдера, зафиксированная Социализмом.

Социальный аккаунт может быть привязан к нескольким учетным записям Яндекса (и наоборот — к одному аккаунту Яндекса можно привязать несколько социальных). Каждая такая связь — это профиль в базе данных Социализма:

![alt text](_assets/profiles.png "Связи профилей" =693x312)

Новые профили создаются в следующих случаях:

* Пользователь авторизован на Яндексе и самостоятельно привязывает аккаунт соцсети к учетной записи Яндекса (например, на странице [Социальные профили](https://social.yandex.ru/)).

* Пользователь [авторизуется с аккаунтом соцсети](http://help.yandex.ru/passport/social.xml), который еще не известен Социализму, и выбирает вариант **Я новый пользователь**. Паспорт автоматически создает учетную запись Яндекса, которую Социализм связывает с используемым аккаунтом соцсети в новом профиле.

    Учетные записи Яндекса, созданные таким образом, не имеют пароля и получают автоматически сгенерированный логин вида «uid-<случайный набор символов>», например, «uid-mmzxrnry». Впоследствии пользователь может [задать собственный логин и пароль](https://doc.yandex-team.ru/Passport/passport-modes/reference/postregistration.html).

Если пользователь входит на Яндекс с аккаунтом соцсети, которому уже соответствует социальный профиль, после успешной аутентификации данные в этом профиле обновятся. Другие профили, в которых указан этот аккаунт соцсети, обновлены не будут.

Помимо идентификаторов двух связанных аккаунтов профиль может содержать:

* Личные данные пользователя, предоставленные провайдером.

* Когда-либо полученные OAuth-токены для запросов API соцсети.

* Признак разрешения на авторизацию. Без этого признака с аккаунтом соцсети невозможно войти в учетную запись Яндекса, указанную в данном профиле.

    Признак автоматически выставляется при первой авторизации с аккаунтом соцсети, в дальнейшем пользователь может управлять им на странице [Социальные профили](https://social.yandex.ru).

* Признаки использования профиля на сервисах Яндекса, например, в [Поиске людей](http://help.yandex.ru/peoplesearch/about.xml). Пользователь может разрешать или запрещать сервисам использовать свои профили на странице [Социальные профили](https://social.yandex.ru).

## Компоненты Социализма {#purpose}

Социализм состоит из следующих компонентов:

1. [Брокер](broker.md) помогает запрашивать информацию об аккаунте социальной сети и привязывать полученные данные к учетным записям Яндекса.

    Брокер также используется для авторизации пользователей социальных сетей на веб-сервисах Яндекса. Чтобы авторизовать таких пользователей, сервис должен перенаправлять их в Паспорт [определенным образом](broker.md#auth).

1. [Прокси](proxy.md) помогает совершать действия в соцсети от имени пользователя (ставить лайки, публиковать посты и прочее).

1. [Хранилище](db.md) позволяет запрашивать данные социальных профилей из базы Социализма.
