const service = 'autofill';
const bucket = process.env.BUCKET || 'passport-static';
const isSdk = bucket.includes('sdk');
const mockFolder = '__no_such_folder';

module.exports = {
    bucket,
    service,
    useYastaticCdn: true,
    version: process.env.npm_package_version || require('./package.json').version,
    static: {
        path: isSdk ? mockFolder : 'public/assets',
        sources: ['**'],
    },
    freeze: {
        path: 'public/scripts',
        sources: ['**'],
        overwrite: true,
        target: service + '/',
    },
};
