module.exports = {
    root: true,
    parser: '@typescript-eslint/parser',
    extends: './node_modules/@yandex-int/lint/eslintrc.js',
    rules: {
        indent: 0,
        'no-undef': 0,
        'import/order': 0,
        'react/jsx-no-bind': 0,
        'operator-linebreak': 0,
        'no-implicit-coercion': 0,
        'no-console': [2, { allow: ['assert', 'error', 'warn', 'info'] }],
        'no-warning-comments': ['error', { terms: ['FIXME'], location: 'anywhere' }],
        'space-before-function-paren': ['error', { anonymous: 'always', named: 'never', asyncArrow: 'always' }],
        'no-use-before-define': 0,
        '@typescript-eslint/no-use-before-define': ['error'],
    },
    overrides: [
        {
            files: ['*.ts', '*.tsx'],
            parserOptions: {
                sourceType: 'module',
            },
        },
        {
            files: ['**/client/**/*'],
            globals: {
                __DEV__: 'readonly',
            },
        },
    ],
};
