require('dns-graceful-stack-switch')(6);
require('dnscache')({
    enable: true,
    ttl: 300,
    cachesize: 1000,
});

const express = require('express');

const app = express();

const IS_DEV = process.env.NODE_ENV === 'development';
const BUILD_SERVER_NOT_FOUND_MODULE_ERROR = "Cannot find module './build/server'";

const rebuild = () => {
    try {
        require('./build/server').default(app);
    } catch (e) {
        if (IS_DEV && e.message.includes(BUILD_SERVER_NOT_FOUND_MODULE_ERROR)) {
            // eslint-disable-next-line no-console
            console.log('building...');
            return setTimeout(rebuild, 3000);
        }

        throw e;
    }
};

rebuild();

module.exports = app;
