const fs = require('fs');
const path = require('path');
const got = require('got');
const tokenator = require('@yandex-int/tokenator');

const secretVersionId = 'ver-01en035855wr3ba2qr96ajfqwf';
const tvmJsonFileName = '.tvm.json';

function getTvmJsonContent(tvmSecret) {
    const tvmJsonTemplate = {
        BbEnvType: 1,
        clients: {
            frontend: {
                secret: tvmSecret,
                self_tvm_id: 2024247,
                dsts: {
                    blackbox: {
                        dst_id: 224,
                    },
                    geo: {
                        dst_id: 2008261,
                    },
                    passport: {
                        dst_id: 2000079,
                    },
                    cloud: {
                        dst_id: 2000060,
                    },
                    socialism: {
                        dst_id: 2000381,
                    },
                },
            },
        },
    };

    return JSON.stringify(tvmJsonTemplate, null, 4);
}

function generateTvmConfig(versionId, fileName, getContent) {
    tokenator(['vault'])
        .then(tokens => {
            const vaultOauthToken = tokens.vault;

            return got(`https://vault-api.passport.yandex.net/1/versions/${versionId}`, {
                headers: {
                    Authorization: `OAuth ${vaultOauthToken}`,
                },
            });
        })
        .then(response => {
            const rootPath = path.join(__dirname, '..');

            const version = JSON.parse(response.body).version;
            const tvmSecret = version.value.find(({ key }) => key === 'client_secret').value;

            fs.writeFileSync(`${rootPath}/${fileName}`, getContent(tvmSecret));
        });
}

generateTvmConfig(secretVersionId, tvmJsonFileName, getTvmJsonContent);
