import './polyfills';
import { includesInArray } from '@common/util';
import { getCookie, setOrigin } from './util';
import { checkAvailability } from './checkAvailability';
import { showIframeAutofill, showPopup, apiCheck, envCheck, setConfig, setStatus, version } from './common';

let process: Promise<{
    status: 'ok' | 'error';
    control: 'iframe' | 'popup' | 'popup_login_required';
    handler: () => Promise<Answer | AnswerWithError>;
}>;
let process2: Promise<Answer | AnswerWithError>;

((window, document) => {
    const location = `${document.location.protocol}//${document.location.hostname}${document.location.pathname}`;
    const ymUid = getCookie('_ym_uid');

    window.YaAutoFill = (() => {
        const init = (
            fields: RequestFields,
            { partner_id: clientID = '', hostname = 'https://autofill.yandex.ru', theme = 'light' } = {},
        ) => {
            let SRC = `${hostname}/embedded?partner_id=${encodeURIComponent(clientID)}&location=${encodeURIComponent(
                location,
            )}&ym_uid=${encodeURIComponent(ymUid)}&theme=${encodeURIComponent(theme)}&fields=${fields.join(
                ',',
            )}&version=${encodeURIComponent(version)}`;
            let SRC2 = `${hostname}/popup?partner_id=${encodeURIComponent(clientID)}&location=${encodeURIComponent(
                location,
            )}&ym_uid=${encodeURIComponent(ymUid)}&theme=${encodeURIComponent(theme)}&fields=${fields.join(
                ',',
            )}&version=${encodeURIComponent(version)}`;
            let targetOrigin = setOrigin(hostname);

            setConfig({
                SRC,
                SRC2,
                targetOrigin,
                clientID,
                fields,
                theme,
            });

            return (
                process ||
                (process = new Promise((resolve, reject) => {
                    checkAvailability({ envCheck, apiCheck: () => apiCheck('autofill') })
                        .then(result =>
                            result.status === 'ok'
                                ? resolve({ status: 'ok', control: 'iframe', handler: showIframeAutofill })
                                : reject(result),
                        )
                        .catch(error => {
                            setStatus(error.code);
                            return includesInArray(['blocked', 'no_data'], error.code)
                                ? resolve({
                                      status: 'ok',
                                      control: 'popup_login_required',
                                      handler: showPopup,
                                  })
                                : reject(error);
                        });
                }))
            );
        };

        return { init };
    })();

    let yandex = window.yandex || (window.yandex = {});
    let autofill = yandex.autofill || (yandex.autofill = {});

    if (typeof autofill.getProfileData !== 'undefined') {
        return;
    }

    autofill.getProfileData = (
        fields: RequestFields,
        { partner_id: clientID = '', hostname = 'https://autofill.yandex.ru', theme = 'light' } = {},
    ) => {
        let SRC = `${hostname}/embedded?partner_id=${encodeURIComponent(clientID)}&location=${encodeURIComponent(
            location,
        )}&ym_uid=${encodeURIComponent(ymUid)}&theme=${encodeURIComponent(theme)}&fields=${fields.join(
            ',',
        )}&version=${encodeURIComponent(version)}`;
        let SRC2 = `${hostname}/popup?partner_id=${encodeURIComponent(clientID)}&location=${encodeURIComponent(
            location,
        )}&ym_uid=${encodeURIComponent(ymUid)}&theme=${encodeURIComponent(theme)}&fields=${fields.join(
            ',',
        )}&version=${encodeURIComponent(version)}`;
        let targetOrigin = setOrigin(hostname);

        setConfig({
            SRC,
            SRC2,
            targetOrigin,
            clientID,
            fields,
            theme,
        });

        return (
            process2 ||
            (process2 = new Promise((resolve, reject) => {
                checkAvailability({ envCheck, apiCheck: () => apiCheck('autofill') })
                    .then(result => {
                        if (result.status === 'ok') {
                            showIframeAutofill()
                                .then(resolve)
                                .catch(error => {
                                    reject({
                                        status: 'error',
                                        code: error,
                                    });
                                });
                        }
                    })
                    .catch(error => {
                        setStatus(error.code);

                        if (error.code === 'blocked' || error.code === 'no_data') {
                            showPopup()
                                .then(resolve)
                                .catch(error => {
                                    reject({
                                        status: 'error',
                                        code: error,
                                    });
                                });
                        } else {
                            reject({
                                status: 'error',
                                code: error.code,
                            });
                        }
                    });
            }))
        );
    };
})(window, window.document);
