import React from 'react';
import ReactDOM from 'react-dom';
import { metrika } from '@common/metrika';
import { addEvent } from '@client/util';
import { jsApiManager } from '@common/browser-manager/js-api';
import { register as registerBrowserManager, getBrowserManager } from '@common/browser-manager';
import { BroApp } from '@common/components/BroApp';

registerBrowserManager(jsApiManager);

const data = {
    models: {
        emails: [],
        phones: [],
        addresses: [],
    },
    users: [],
    profiles: [],
    locals: window.__LOCALS__,
    meta: window.__META__,
    initialError: window.__INITIAL_ERRORS__,
    constants: window.__CONSTANTS__,
};

addEvent(window, 'keydown', e => {
    if (e.code === 'Escape') {
        metrika.params({
            close: 'escape',
        });
        getBrowserManager().onClose();
    }
});

ReactDOM.render(<BroApp initialData={data} />, document.getElementById('root'));
