export const checkAvailability = ({
    envCheck,
    apiCheck,
}: {
    envCheck: () => Promise<EnvCheckResult>;
    apiCheck: () => Promise<ApiCheckResult>;
}) =>
    envCheck()
        .then(envResult => {
            const { status, code } = envResult;

            if (status === 'error') {
                throw new Error(code);
            }

            return apiCheck();
        })
        .then(apiResult => {
            const { elem, send, subscribe, show, destroy } = apiResult;

            return {
                status: 'ok',
                elem,
                send,
                subscribe,
                show,
                destroy,
            };
        });
