import { ProviderData } from '../types';

declare module '*.css' {
    const classNames: Record<string, string>;
    export default classNames;
}

type MessageData = { cause: string; type: string; payload?: object };

type ResultField = 'firstName' | 'lastName' | 'phone' | 'email' | 'address';
type RequestField = 'name' | 'phone' | 'email' | 'address';

type RequestFields = Array<RequestField>;
type ResultFields = Array<ResultField>;

type Result = {
    firstName?: string;
    lastName?: string;
    phone?: string;
    address?: string;
    email?: string;
};

type Answer = {
    firstName?: string;
    lastName?: string;
    phoneNumber?: string;
    streetAddress?: string;
    email?: string;
};

type AnswerWithError = {
    status: 'error';
    code?: string;
};

type Payload = { error?: { code: string } };

type Config = {
    clientID: string;
    targetOrigin: string;
    tokenPageOrigin?: string;
    SRC: string;
    SRC2: string;
    fields: RequestFields;
    theme: string;
};

type EnvCheckResult = {
    error?: null;
    code?: string;
    status?: 'error';
};

type ApiCheckResult = {
    status?: 'error' | 'ok';
    code?: string;
    elem?: HTMLIFrameElement | Window | null;
    send?: (data: MessageData) => Promise<MessageData>;
    subscribe?: (handler: (data: MessageData, e: MessageEvent) => void) => void;
    show?: () => void;
    destroy?: () => void;
};

declare var POLYFILLS: boolean | undefined;
declare var VERSION: string | undefined;

interface Window {
    __CSRF__: string;
    __META__: import('../types').Meta;
    __PROFILES__: import('../types').UserProfile[];
    __LOCALS__: import('../types').RenderProps['locals'];
    __USER__: import('../types').User | null;
    __USERS__: import('../types').SuggestUser[] | null;
    __PROVIDER__?: ProviderData;
    __CONSTANTS__: import('../types').Constants;
    __INITIAL_ERRORS__: import('../types').InitialErrors;
    __ORIGIN__: string;
    __RESULT__: object;
    popupWindow?: Window | null;
    chrome?: {
        runtime: {
            lastError?: {
                message: string;
            };
        };
    };
    yandex?: {
        autofill?: {
            getProfileData?: (
                fields: RequestFields,
                {
                    partner_id: clientID,
                    hostname,
                    theme,
                }?: { partner_id?: string | undefined; hostname?: string | undefined; theme?: string | undefined },
            ) => Promise<Answer | AnswerWithError>;
        };
        autofillBubblePrivate?: {
            getBubbleData: (cb: (data: import('../types').AutofillProfilePresets) => void) => void;
            setBubbleResponse: (profile: import('../types').AutofillProfile | null) => void;
        };
    };
    YaAutoFill: {
        init: (
            fields: RequestFields,
            {
                partner_id: clientID,
                hostname,
                theme,
            }?: { partner_id?: string | undefined; hostname?: string | undefined; theme?: string | undefined },
        ) => Promise<{
            status: 'ok' | 'error';
            handler: () => Promise<Answer | AnswerWithError>;
        }>;
    };
    YaAuthSuggest: {
        init: (
            params: OauthQueryParams,
            tokenPageOrigin: string,
            { 
                parentId,
                hostname,
                theme,
                view,
                buttonView,
                buttonTheme, 
                buttonSize,
                buttonBorderRadius
            }?: { parentId?: string; hostname?: string; theme?: string; view?: string; buttonView?: string; buttonTheme?: string, buttonSize?: string, buttonBorderRadius?: Number },
        ) => Promise<{
            status: 'ok' | 'error';
            handler: () => Promise<object | undefined>;
        }>;
    };
    YaAuthDataProvider: {
        initSave: (
            { processName, isDrawer }: { processName: string; isDrawer: boolean },
            { hostname, theme }?: { hostname?: string; theme?: string },
        ) => Promise<{
            status: 'ok' | 'error';
            handler: () => Promise<object | undefined>;
        }>;
        initAutoFill: (
            { processName, isDrawer }: { processName: string; isDrawer: boolean },
            { hostname, theme }?: { hostname?: string; theme?: string },
        ) => Promise<{
            status: 'ok' | 'error';
            handler: () => Promise<object | undefined>;
        }>;
        close: () => void;
    };
    YaSocialIntegration: (
        cb: (obj: Object) => {},
        socialArgs: { appName: string; scope: string; consumer: string },
    ) => {
        renderButton: (rootId: string) => void;
    };
    YaSendSuggestToken: (origin: string, extraData?: object) => void;
}

interface HTMLElementEventMap {
    message: MessageEvent;
    DOMContentLoaded: Event;
    CustomEvent: CustomEvent;
    input: Event & { target: HTMLInputElement | null };
    change: Event & { target: HTMLInputElement | null };
}
