import { receiveMessage } from './util';
import { getConfig } from './common';
import { IframeType } from './types';
import { personalButtonStub } from '@common/components/PersonalButton/PersonalButtonStub';
import { removePersonalButtonStub } from '@common/components/PersonalButton/utils';

export type StubControl = {
    subscribe: (handler: (data: MessageData, e: MessageEvent) => void) => void;
    show: () => void;
    destroy: () => void;
};

export const getStubControl: (type: IframeType) => Promise<Control> = type => {
    const { targetOrigin, tokenPageOrigin = '', parentId = '', suggestButtonOptions } = getConfig();

    return new Promise(resolve => {
        const subscribe = (handler: (data: MessageData, e: MessageEvent) => void) => {
            const handlers: (() => void)[] = [];
            handlers.push(receiveMessage(targetOrigin, handler));
            if (type === 'suggest' && tokenPageOrigin) {
                handlers.push(receiveMessage(tokenPageOrigin, handler));
            }

            return () => handlers.forEach(handler => handler());
        };

        const destroy = () => {
            removePersonalButtonStub();
        };

        const show = () => {
            personalButtonStub({ targetOrigin, parentId, suggestButtonOptions });
        };

        resolve({
            subscribe,
            destroy,
            show,
        });
    });
};
