import type { UserModels, UserProfile } from '@src/types';

export const isAvailable = () => {
    return Boolean(window.yandex?.autofillBubblePrivate);
};

export const getAppData = () => {
    return new Promise<{ models: UserModels; profiles: UserProfile[] }>((resolve, reject) => {
        window.yandex?.autofillBubblePrivate?.getBubbleData(({ profiles, models }) => {
            if (window.chrome?.runtime.lastError) {
                return reject(new Error(window.chrome?.runtime.lastError.message));
            }

            resolve({
                profiles: profiles.map(({ firstName, lastName, email, phoneNumber, streetAddress }) => ({
                    firstName,
                    lastName,
                    phone: phoneNumber,
                    email,
                    address: streetAddress,
                })),
                models: {
                    emails: models.email,
                    phones: models.phone,
                    addresses: models.address,
                },
            });
        });
    });
};

export const close = (data?: UserProfile) => {
    return window.yandex?.autofillBubblePrivate?.setBubbleResponse(
        data
            ? {
                  firstName: data.firstName ?? '',
                  middleName: data.middleName ?? '',
                  lastName: data.lastName ?? '',
                  fullName: data.fullName ?? '',
                  email: data.email ?? '',
                  phoneNumber: data.phone ?? '',
                  streetAddress: data.address ?? '',
              }
            : null,
    );
};
