type Params = {
    metrikaId?: string | null;
    encodedBoxes?: string | null;
};

export default class Metrika {
    private _counter?: ANY;
    private _firstTime = true;
    private _goalTracer: { [_ in string]?: boolean } = {};
    static callback(...fns: Function[]) {
        if (typeof window !== 'undefined' && Array.isArray(window.yandex_metrika_callbacks2)) {
            window.yandex_metrika_callbacks2.push(...fns);
        }
    }

    public constructor({ metrikaId, encodedBoxes }: Params) {
        if (typeof window !== 'undefined' && metrikaId) {
            window.yandex_metrika_callbacks2 = [];
            Metrika.callback(() => {
                try {
                    this._counter = new (window as ANY).Ya.Metrika2({
                        id: metrikaId,
                        clickmap: true,
                        trackLinks: true,
                        accurateTrackBounce: true,
                        webvisor: true,
                        experiments: encodedBoxes,
                    });
                } catch (e) {
                    // empty
                }
            });
            const n = window.document.getElementsByTagName('script')[0];
            const s = window.document.createElement('script');
            s.type = 'text/javascript';
            s.async = true;
            s.src = 'https://mc.yandex.ru/metrika/tag.js';
            n && n.parentNode && n.parentNode.insertBefore(s, n);
        }
    }
    private call(method: string, ...args: unknown[]) {
        const fn = () => {
            this._counter[method](...args);
        };
        if (this._counter) {
            fn();
        } else {
            Metrika.callback(fn);
        }
    }
    public hit(url: string, opts?: { referer?: string } & Record<string, string>) {
        if (this._firstTime) {
            this._firstTime = false;
        } else {
            // Beware: Metrika uses 'referer' with one 'r';
            this.call('hit', url, opts);
        }
    }
    public reachGoal(goal: string, params: object) {
        this.call('reachGoal', goal, params);
    }
    public reachGoalOnce(goal: string, params: object) {
        if (!this._goalTracer[goal]) {
            this.call('reachGoal', goal, params);
            this._goalTracer[goal] = true;
        }
    }
    public userParams(params: object) {
        this.call('userParams', params);
    }
    public params(params: object) {
        this.call('params', params);
    }
}
