import './polyfills';
import { setOrigin, sendMessage } from './util';
import { checkAvailability } from './checkAvailability';
import { showIframeProvider, apiCheck, envCheck, setConfig, setStatus } from './common';
import { messages } from '@client/constants';

let process: Promise<{
    status: 'ok' | 'error';
    handler: () => Promise<object | undefined>;
}>;

(window => {
    window.YaAuthDataProvider = (() => {
        const origin = `${document.location.protocol}//${document.location.hostname}`;
        const initConfig = (
            { processName = 'save', isDrawer = false },
            { hostname = 'https://autofill.yandex.ru', theme = 'light' } = {},
        ) => {
            let SRC = `${hostname}/provider?processName=${processName}&drawer=${
                isDrawer ? 1 : 0
            }&origin=${encodeURIComponent(origin)}`;
            let targetOrigin = setOrigin(hostname);

            setConfig({
                SRC,
                SRC2: SRC,
                targetOrigin,
                clientID: '',
                fields: [],
                theme,
            });
        };

        const getProcess = () => {
            return (
                process ||
                (process = new Promise((resolve, reject) => {
                    checkAvailability({ envCheck, apiCheck: () => apiCheck('provider') })
                        .then(result =>
                            result.status === 'ok'
                                ? resolve({ status: 'ok', handler: showIframeProvider })
                                : reject(result),
                        )
                        .catch(error => {
                            setStatus(error.code);
                            return reject(error);
                        });
                }))
            );
        };
        const initSave = ({ isDrawer = false } = {}, options = {}) => {
            initConfig({ processName: 'save', isDrawer }, options);

            return getProcess();
        };

        const initAutoFill = ({ isDrawer = false } = {}, options = {}) => {
            initConfig({ processName: 'autofill', isDrawer }, options);

            return getProcess();
        };

        const close = () => sendMessage({ cause: 'provider', type: messages.closeBySdk }, `${document.location.protocol}//${document.location.hostname}`, window);

        return { initSave, initAutoFill, close };
    })();
})(window);
