import { messages } from './constants';
import { receiveMessage, sendMessage } from './util';

window.onload = () => {
    const { __ORIGIN__: origin, __RESULT__: result } = window;

    receiveMessage(origin, ({ type, cause }: MessageData) => {
        if (type === messages.close && cause === 'social') {
            window.close();
        }
    });
    return sendMessage({ cause: 'social', type: messages.social, payload: result }, origin, window.opener);
};
