import './polyfills';
import './social.css';
import { receiveMessage, sendMessage, setOrigin } from './util';
import { messages } from './constants';

(window => {
    window.YaSocialIntegration = (
        cb: (obj: Object) => void,
        { appName, scope, consumer },
        { hostname = 'https://autofill.yandex.ru' } = {},
    ) => {
        let targetOrigin = setOrigin(hostname);
        let win: Window | null;

        receiveMessage(targetOrigin, ({ cause, type, payload }) => {
            if (cause === 'social' && type === messages.social) {
                cb({ ...payload });
                sendMessage({ cause: 'social', payload: {}, type: messages.close }, targetOrigin, win);
            }
        });

        return {
            renderButton: (rootId: string) => {
                const root = document.getElementById(rootId);

                if (root) {
                    const button = document.createElement('button');
                    button.className = 'YaSocialButton';

                    const top = document.createElement('div');
                    top.className = 'YaSocialButton-logo';

                    const bottom = document.createElement('div');
                    bottom.innerHTML = 'Заполнить из госуслуг';
                    bottom.className = 'YaSocialButton-text';

                    const arrow = document.createElement('div');
                    arrow.className = 'YaSocialButton-arrow';

                    button.appendChild(top);
                    button.appendChild(bottom);
                    button.appendChild(arrow);

                    button.onclick = () => {
                        if (win) {
                            win.close();
                        }

                        win = window.open(
                            `${hostname}/social/start?appName=${appName}&scope=${scope}&consumer=${consumer}&origin=${encodeURIComponent(
                                `${document.location.protocol}//${document.location.hostname}`,
                            )}`,
                            'social',
                            `left=${(window.screen.width - 400) / 2}, top=${
                                (window.screen.height - 400) / 2
                            }, width=400, height=400, scrollbars=no`,
                        );
                    };

                    root.appendChild(button);
                } else {
                    cb({ state: 'error', data: { code: 'no-root' } });
                }
            },
        };
    };
})(window);
