import './polyfills';
import { getCookie, setOrigin } from './util';
import { checkAvailability } from './checkAvailability';
import { showIframeSuggest, showSuggestButtonStub, apiCheck, envCheck, setConfig, setStatus, version } from './common';

let process: Promise<{
    status: 'ok' | 'error';
    handler: () => Promise<object | undefined>;
}>;

((window, document) => {
    const location = `${document.location.protocol}//${document.location.hostname}${document.location.pathname}`;
    const ymUid = getCookie('_ym_uid');

    window.YaAuthSuggest = (() => {
        const init = (
            params: OauthQueryParams,
            tokenPageOrigin: string,
            {
                hostname = 'https://autofill.yandex.ru',
                theme = 'light',
                view = 'default',
                parentId = '',
                buttonView = 'main',
                buttonTheme = 'light',
                buttonSize = 'm',
                buttonBorderRadius = 0,
            } = {},
        ) => {
            let SRC = `${hostname}/suggest?${Object.keys(params)
                .map(key => `${key}=${encodeURIComponent(String(params[key]))}`)
                .join('&')}&location=${encodeURIComponent(location)}&ym_uid=${encodeURIComponent(
                ymUid,
            )}&theme=${encodeURIComponent(theme)}&version=${encodeURIComponent(version)}&suggest_view=${encodeURIComponent(view)}`;

            if (['button'].includes(view)) {
                SRC = `${SRC}&button_view=${encodeURIComponent(buttonView)}&button_theme=${encodeURIComponent(buttonTheme)}&button_size=${encodeURIComponent(buttonSize)}&button_border_radius=${encodeURIComponent(buttonBorderRadius)}`;
            }

            let targetOrigin = setOrigin(hostname);

            setConfig({
                SRC,
                SRC2: SRC,
                targetOrigin,
                tokenPageOrigin,
                clientID: '',
                fields: [],
                theme,
                parentId,
                suggestView: view,
                suggestButtonOptions: {
                    buttonView,
                    buttonTheme,
                    buttonSize,
                    buttonBorderRadius,
                },
            });

            return (
                process ||
                (process = new Promise((resolve, reject) => {
                    checkAvailability({ envCheck, apiCheck: () => apiCheck('suggest') })
                        .then(result => {
                            if (result.status === 'ok') {
                                return resolve({ status: 'ok', handler: () => showIframeSuggest() });
                            } else if (['button'].includes(view)) {
                                return resolve({ status: 'ok', handler: () => showSuggestButtonStub() });
                            }
                            reject(result);
                        },
                        )
                        .catch(error => {
                            if (['button'].includes(view)) {
                                return resolve({ status: 'ok', handler: () => showSuggestButtonStub() });
                            }

                            setStatus(error.code);
                            return reject(error);
                        });
                }))
            );
        };

        return { init };
    })();
})(window, window.document);
