import './polyfills';
import { messages } from './constants';
import { receiveMessage, sendMessage } from './util';

window.YaSendSuggestToken = (origin: string, extraData?: object) => {
    let warnMessage = 'Необходимо указать ориджин в виде строки, не содержащий *';
    if (origin && typeof origin === 'string' && origin.indexOf('*') === -1) {
        let message: Record<string, string> = {};
        if (window.location.hash || window.location.search) {
            [window.location.hash, window.location.search].forEach(
                str =>
                    str &&
                    str
                        .slice(1)
                        .split('&')
                        .forEach(i => {
                            const [key, value] = i.split('=');
                            message[key] = value;
                        }),
            );
            if (window.opener?.parent) {
                receiveMessage(origin, (data: MessageData) => {
                    data.type === messages.close && window.close();
                });
                return sendMessage(
                    {
                        cause: 'token',
                        type: messages.token,
                        payload: extraData !== undefined ? { ...message, extraData } : message,
                    },
                    origin,
                    window.opener.parent,
                );
            }
            warnMessage = 'Данная страница открыта не в отдельном окне';
        } else {
            warnMessage = 'Не удалось получить информмацию о токене';
        }
    }
    console.warn(warnMessage);
};
